/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.serialize;

import com.tttsaurus.ingameinfo.shadow.io.leangen.geantyref.TypeToken;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.serialize.AbstractListChildSerializer;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.serialize.SerializationException;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.util.CheckedConsumer;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    static final TypeToken<List<?>> TYPE = new TypeToken<List<?>>(){};

    ListSerializer() {
    }

    @Override
    protected AnnotatedType elementType(AnnotatedType containerType) throws SerializationException {
        if (!(containerType instanceof AnnotatedParameterizedType)) {
            throw new SerializationException(containerType, "Raw types are not supported for collections");
        }
        return ((AnnotatedParameterizedType)containerType).getAnnotatedActualTypeArguments()[0];
    }

    @Override
    protected List<?> createNew(int length, AnnotatedType elementType) {
        return new ArrayList(length);
    }

    @Override
    protected void forEachElement(List<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    protected void deserializeSingle(int index, List<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

