/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.animation;

import net.minecraft.util.math.MathHelper;

public class SmoothDamp {
    private float dis;
    private float from;
    private float to;
    private float vel;
    private final float smoothTime;
    private final float maxSpeed;

    public float getFrom() {
        return this.from;
    }

    public void setFrom(float from) {
        this.from = from;
        this.dis = Math.abs(this.to - from);
    }

    public float getTo() {
        return this.to;
    }

    public void setTo(float to) {
        this.to = to;
        this.dis = Math.abs(to - this.from);
    }

    public SmoothDamp(float from, float to, float smoothTime) {
        this.dis = Math.abs(to - from);
        this.from = from;
        this.to = to;
        this.vel = 0.0f;
        this.smoothTime = Math.max(smoothTime * 0.268f, 0.001f);
        this.maxSpeed = Float.POSITIVE_INFINITY;
    }

    public SmoothDamp(float from, float to, float smoothTime, float maxSpeed) {
        this.dis = Math.abs(to - from);
        this.from = from;
        this.to = to;
        this.vel = 0.0f;
        this.smoothTime = Math.max(smoothTime * 0.268f, 0.001f);
        this.maxSpeed = maxSpeed;
    }

    public float evaluate(float deltaTime) {
        float omega = 2.0f / this.smoothTime;
        float x = omega * deltaTime;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = this.to - this.from;
        float maxChange = this.maxSpeed * this.smoothTime;
        change = MathHelper.func_76131_a((float)change, (float)(-maxChange), (float)maxChange);
        float temp = (this.vel - omega * change) * deltaTime;
        this.vel = (this.vel - omega * temp) * exp;
        this.from = this.from + change + (temp - change) * exp;
        if (Math.abs(this.to - this.from) <= 0.005f * this.dis) {
            this.from = this.to;
        }
        return this.from;
    }
}

