/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.commonutils;

import com.tttsaurus.ingameinfo.common.core.serialization.Deserializer;
import com.tttsaurus.ingameinfo.common.impl.serialization.ItemDeserializer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Deserializer(value=ItemDeserializer.class)
public final class GhostableItem {
    private final String raw;
    private int meta;
    private ResourceLocation resourceLocation;
    private boolean isGhost = false;
    private boolean doesntExist = false;
    private ItemStack itemStack;
    private boolean isAbortNextTime = false;

    public GhostableItem(@Nonnull ItemStack itemStack) {
        this.itemStack = itemStack;
        this.raw = itemStack.func_77973_b().getRegistryName() == null ? "null" : itemStack.func_77973_b().getRegistryName().toString() + ":" + itemStack.func_77960_j();
    }

    public GhostableItem(String registryName) {
        Item item;
        this.itemStack = null;
        this.raw = registryName;
        String[] args = registryName.split(":");
        if (args.length <= 1 || args.length > 3) {
            this.doesntExist = true;
            return;
        }
        this.resourceLocation = new ResourceLocation(args[0], args[1]);
        this.meta = 0;
        if (args.length == 3) {
            try {
                this.meta = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(this.resourceLocation)) == null) {
            this.isGhost = true;
            return;
        }
        this.itemStack = new ItemStack(item, 1, this.meta);
    }

    public void abortNextTime() {
        this.isAbortNextTime = true;
    }

    @Nullable
    public ItemStack getItemStack() {
        if (this.doesntExist) {
            return null;
        }
        if (this.isGhost) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.resourceLocation);
            if (item != null) {
                this.isGhost = false;
                this.itemStack = new ItemStack(item, 1, this.meta);
            } else if (this.isAbortNextTime) {
                this.doesntExist = true;
            }
        }
        if (this.itemStack == null) {
            return null;
        }
        return this.itemStack;
    }

    public String toString() {
        return "GhostableItem{raw=" + this.raw + ", isGhost=" + this.isGhost + ", doesntExist=" + this.doesntExist + '}';
    }
}

