/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.layout;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.DebugRectOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.input.InputState;
import java.util.ArrayList;
import java.util.List;

@RegisterElement(constructable=false)
public abstract class ElementGroup
extends Element {
    public final List<Element> elements = new ArrayList<Element>();

    public void add(Element element) {
        InternalMethods.instance.Element$parent$setter.invoke(element, this);
        this.elements.add(element);
    }

    public void add(int index, Element element) {
        InternalMethods.instance.Element$parent$setter.invoke(element, this);
        this.elements.add(index, element);
    }

    @Override
    public void applyLogicTheme(ThemeConfig themeConfig) {
        super.applyLogicTheme(themeConfig);
        for (Element element : this.elements) {
            element.applyLogicTheme(themeConfig);
        }
    }

    @Override
    public void resetRenderInfo() {
        super.resetRenderInfo();
        for (Element element : this.elements) {
            element.resetRenderInfo();
        }
    }

    @Override
    public void calcWidthHeight() {
        for (Element element : this.elements) {
            element.calcWidthHeight();
            if (element.enabled) continue;
            element.cachedWidth = element.rect.width;
            element.cachedHeight = element.rect.height;
            element.rect.width = 0.0f;
            element.rect.height = 0.0f;
        }
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
        if (!this.enabled) {
            return;
        }
        super.onFixedUpdate(deltaTime);
        for (Element element : this.elements) {
            if (!element.enabled) continue;
            element.onFixedUpdate(deltaTime);
        }
    }

    @Override
    public void onCollectLerpInfo() {
        super.onCollectLerpInfo();
        for (Element element : this.elements) {
            element.onCollectLerpInfo();
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        if (!this.enabled) {
            return;
        }
        super.onRenderUpdate(queue, focused);
        for (Element element : this.elements) {
            if (!element.enabled) continue;
            element.onRenderUpdate(queue, focused);
        }
    }

    @Override
    public void onPropagateInput(InputState inputState) {
        if (!this.enabled) {
            return;
        }
        if (inputState.isConsumed()) {
            return;
        }
        super.onPropagateInput(inputState);
        for (Element element : this.elements) {
            if (element.enabled) {
                element.onPropagateInput(inputState);
            }
            if (!inputState.isConsumed()) continue;
            return;
        }
    }

    @Override
    public boolean getNeedReCalc() {
        if (super.getNeedReCalc()) {
            return true;
        }
        for (Element element : this.elements) {
            if (!element.getNeedReCalc()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finishReCalc() {
        super.finishReCalc();
        for (Element element : this.elements) {
            element.finishReCalc();
        }
    }

    @Override
    public void renderDebugRect(RenderOpQueue queue) {
        for (Element element : this.elements) {
            element.renderDebugRect(queue);
        }
        queue.enqueue(new DebugRectOp(true, this.rect, this.pivotPosX, this.pivotPosY));
    }
}

