/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.command;

import com.tttsaurus.ingameinfo.common.core.reflection.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class VisualCommand {
    private final List<List<Class<?>>> paramLayouts = new ArrayList();

    protected final Object[] castArgs(int layout, Object ... args) {
        List<Class<?>> params = this.paramLayouts.get(layout);
        for (int i = 0; i < args.length; ++i) {
            Class<?> expect = params.get(i);
            Object object = args[i];
            if (object instanceof Byte) {
                Byte arg = (Byte)object;
                if (expect == Short.TYPE) {
                    args[i] = arg.shortValue();
                }
                if (expect == Integer.TYPE) {
                    args[i] = arg.intValue();
                }
                if (expect == Long.TYPE) {
                    args[i] = arg.longValue();
                }
                if (expect == Float.TYPE) {
                    args[i] = Float.valueOf(arg.floatValue());
                }
                if (expect != Double.TYPE) continue;
                args[i] = arg.doubleValue();
                continue;
            }
            object = args[i];
            if (object instanceof Short) {
                Short arg = (Short)object;
                if (expect == Integer.TYPE) {
                    args[i] = arg.intValue();
                }
                if (expect == Long.TYPE) {
                    args[i] = arg.longValue();
                }
                if (expect == Float.TYPE) {
                    args[i] = Float.valueOf(arg.floatValue());
                }
                if (expect != Double.TYPE) continue;
                args[i] = arg.doubleValue();
                continue;
            }
            object = args[i];
            if (object instanceof Character) {
                Character arg = (Character)object;
                if (expect == Integer.TYPE) {
                    args[i] = (int)arg.charValue();
                }
                if (expect == Long.TYPE) {
                    args[i] = (long)arg.charValue();
                }
                if (expect == Float.TYPE) {
                    args[i] = Float.valueOf(arg.charValue());
                }
                if (expect != Double.TYPE) continue;
                args[i] = (double)arg.charValue();
                continue;
            }
            object = args[i];
            if (object instanceof Integer) {
                Integer arg = (Integer)object;
                if (expect == Long.TYPE) {
                    args[i] = arg.longValue();
                }
                if (expect == Float.TYPE) {
                    args[i] = Float.valueOf(arg.floatValue());
                }
                if (expect != Double.TYPE) continue;
                args[i] = arg.doubleValue();
                continue;
            }
            object = args[i];
            if (object instanceof Long) {
                Long arg = (Long)object;
                if (expect == Float.TYPE) {
                    args[i] = Float.valueOf(arg.floatValue());
                }
                if (expect != Double.TYPE) continue;
                args[i] = arg.doubleValue();
                continue;
            }
            object = args[i];
            if (!(object instanceof Float)) continue;
            Float arg = (Float)object;
            if (expect != Double.TYPE) continue;
            args[i] = arg.doubleValue();
        }
        return args;
    }

    private final boolean matchClass(Class<?> expect, Class<?> in) {
        if (Objects.equals(expect, in)) {
            return true;
        }
        if (in == Byte.TYPE) {
            return expect == Short.TYPE || expect == Integer.TYPE || expect == Long.TYPE || expect == Float.TYPE || expect == Double.TYPE;
        }
        if (in == Short.TYPE) {
            return expect == Integer.TYPE || expect == Long.TYPE || expect == Float.TYPE || expect == Double.TYPE;
        }
        if (in == Character.TYPE) {
            return expect == Integer.TYPE || expect == Long.TYPE || expect == Float.TYPE || expect == Double.TYPE;
        }
        if (in == Integer.TYPE) {
            return expect == Long.TYPE || expect == Float.TYPE || expect == Double.TYPE;
        }
        if (in == Long.TYPE) {
            return expect == Float.TYPE || expect == Double.TYPE;
        }
        if (in == Float.TYPE) {
            return expect == Double.TYPE;
        }
        return false;
    }

    protected final int matchParams(Object ... args) {
        int i;
        Class[] params = new Class[args.length];
        for (i = 0; i < params.length; ++i) {
            Class<?> clazz = args[i].getClass();
            if (TypeUtils.isWrappedPrimitive(clazz)) {
                clazz = TypeUtils.toPrimitive(clazz);
            }
            params[i] = clazz;
        }
        for (i = 0; i < this.paramLayouts.size(); ++i) {
            List<Class<?>> _params = this.paramLayouts.get(i);
            if (_params.size() != params.length) continue;
            boolean eq = true;
            for (int j = 0; j < _params.size(); ++j) {
                if (this.matchClass(_params.get(j), params[j])) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return i;
        }
        return -1;
    }

    protected static List<Class<?>> params(Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!TypeUtils.isWrappedPrimitive(classes[i])) continue;
            classes[i] = TypeUtils.toPrimitive(classes[i]);
        }
        return Arrays.asList(classes);
    }

    @SafeVarargs
    protected VisualCommand(List<Class<?>> ... layouts) {
        this.paramLayouts.addAll(Arrays.asList(layouts));
    }

    public abstract void execute(Object ... var1);
}

