/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.render.RenderMask;

public class MaskStartOp
implements IRenderOp {
    public boolean rounded;
    public Rect rect;
    public float cornerRadius;

    public MaskStartOp(Rect rect) {
        this.rect = rect;
        this.rounded = false;
    }

    public MaskStartOp(Rect rect, float cornerRadius) {
        this.rect = rect;
        this.cornerRadius = cornerRadius;
        this.rounded = true;
    }

    @Override
    public void execute(RenderContext context) {
        RenderMask mask;
        if (this.rounded) {
            mask = new RenderMask(RenderMask.MaskShape.ROUNDED_RECT);
            mask.setRoundedRectMask(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.cornerRadius);
        } else {
            mask = new RenderMask(RenderMask.MaskShape.RECT);
            mask.setRectMask(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        mask.startMasking();
    }
}

