/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.theme;

import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfigUpdater;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.CommentedConfigurationNode;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.ConfigurationNode;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.objectmapping.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class ThemeConfigSerDesUtils {
    public static String serialize(ThemeConfig config) throws IOException {
        StringWriter writer = new StringWriter();
        NonClosingBufferedWriter bufferedWriter = new NonClosingBufferedWriter(writer);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().sink(() -> bufferedWriter)).build();
        Object root = loader.createNode();
        ((CommentedConfigurationNode)root.node("version").set(1)).comment("Don't touch 'version' manually. This is an indicator for config updater.");
        root.node("config").set(config);
        loader.save((ConfigurationNode)root);
        bufferedWriter.flush();
        bufferedWriter.closeHint = true;
        bufferedWriter.close();
        return writer.toString();
    }

    public static ThemeConfigUpdater deserialize(String raw) throws IOException {
        StringReader reader = new StringReader(raw);
        BufferedReader bufferedReader = new BufferedReader(reader);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().source(() -> bufferedReader)).build();
        Object root = loader.load();
        bufferedReader.close();
        ObjectMapper.Factory factory = ObjectMapper.factory();
        ObjectMapper<ThemeConfig> mapper = factory.get(ThemeConfig.class);
        return new ThemeConfigUpdater(mapper.load(root.node("config")), root.node("version").getInt(), (ConfigurationNode)root);
    }

    private static class NonClosingBufferedWriter
    extends BufferedWriter {
        public boolean closeHint = false;

        public NonClosingBufferedWriter(Writer out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            if (this.closeHint) {
                super.close();
            } else {
                super.flush();
            }
        }
    }
}

