/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.compose;

import com.tttsaurus.ingameinfo.common.core.function.IAction;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeNode;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeValidator;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.SnapshotTree;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ComposeNodeWorkspace {
    private final ComposeNode node;
    private final SnapshotTree tree;
    private boolean enableUserKey = false;
    private final AtomicInteger sysKeyCounter;
    private final ComposeValidator validator;
    private final AtomicBoolean abortThisFrame;

    protected ComposeNodeWorkspace(ComposeNode node, SnapshotTree tree, AtomicInteger sysKeyCounter, ComposeValidator validator, AtomicBoolean abortThisFrame) {
        this.node = node;
        this.tree = tree;
        this.sysKeyCounter = sysKeyCounter;
        this.validator = validator;
        this.abortThisFrame = abortThisFrame;
    }

    public ComposeNodeWorkspace prop(String stylePropertyName, Object value) {
        this.node.styleProperties.put(stylePropertyName, value);
        return this;
    }

    public ComposeNodeWorkspace key(int key) {
        return this.key(String.valueOf(key));
    }

    public ComposeNodeWorkspace key(String key) {
        if (!this.enableUserKey) {
            this.enableUserKey = true;
            this.sysKeyCounter.decrementAndGet();
        }
        this.node.userKey = "!" + key;
        return this;
    }

    public void wrap(IAction action) {
        if (!this.validator.group(this.node.uiElementName)) {
            this.validator.error("Failed to wrap because " + this.node.uiElementName + " is not a ElementGroup. This frame will be aborted.");
            this.abortThisFrame.set(true);
        }
        this.tree.gotoNextLayer();
        action.invoke();
        this.tree.gotoPrevLayer();
    }
}

