/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.compose;

import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeNode;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.UpdatePlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SnapshotTree {
    private final ComposeNode rootNode;
    private ComposeNode currRootNode;
    private ComposeNode lastVisitedNode;

    public SnapshotTree() {
        this.currRootNode = this.rootNode = new ComposeNode("ROOT", null, -1);
        this.lastVisitedNode = this.rootNode;
    }

    public ComposeNode add(String name, int sysKey) {
        ComposeNode newNode = new ComposeNode(name, this.currRootNode, sysKey);
        this.currRootNode.children.add(newNode);
        this.lastVisitedNode = newNode;
        return newNode;
    }

    public void gotoNextLayer() {
        this.currRootNode = this.lastVisitedNode;
    }

    public void gotoPrevLayer() {
        if (this.currRootNode.parent != null) {
            this.currRootNode = this.currRootNode.parent;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append("\n");
        SnapshotTree.recursiveToString(this.rootNode, builder, 0);
        return builder.toString();
    }

    private static void recursiveToString(ComposeNode root, StringBuilder builder, int depth) {
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        builder.append(root.uiElementName).append("\n");
        for (ComposeNode node : root.children) {
            SnapshotTree.recursiveToString(node, builder, depth + 1);
        }
    }

    private static void swaps(List<UpdatePlan> updatePlans, List<ComposeNode> nodes, Map<Integer, Integer> perm) {
        HashSet<Integer> visited = new HashSet<Integer>();
        for (Integer start : perm.keySet()) {
            if (visited.contains(start)) continue;
            ArrayList<Integer> cycle = new ArrayList<Integer>();
            Integer current = start;
            while (!visited.contains(current)) {
                cycle.add(current);
                visited.add(current);
                Integer next = perm.get(current);
                if (next == null) break;
                current = next;
            }
            for (int i = 1; i < cycle.size(); ++i) {
                UpdatePlan plan = new UpdatePlan((Integer)cycle.get(0), UpdatePlan.ActionType.SWAP);
                plan.swapIndex = (Integer)cycle.get(i);
                Collections.swap(nodes, plan.index, plan.swapIndex);
                updatePlans.add(plan);
            }
        }
    }

    private static void recursiveDiff(List<UpdatePlan> updatePlans, ComposeNode oldRoot, ComposeNode newRoot) {
        HashMap<ComposeNode, ComposeNode> correspondingNodes = new HashMap<ComposeNode, ComposeNode>();
        int i = 0;
        int shift = 0;
        for (ComposeNode node1 : oldRoot.children) {
            UpdatePlan plan;
            UpdatePlan plan2;
            Object oldValue;
            ComposeNode node2;
            boolean hasCorresponding;
            if (node1.children.isEmpty()) {
                hasCorresponding = false;
                for (int j = 0; j < newRoot.children.size(); ++j) {
                    node2 = newRoot.children.get(j);
                    if (!node2.children.isEmpty() || !node1.uiElementName.equals(node2.uiElementName) || !node1.getFinalKey().equals(node2.getFinalKey()) || !node2.styleProperties.keySet().containsAll(node1.styleProperties.keySet())) continue;
                    correspondingNodes.put(node1, node2);
                    hasCorresponding = true;
                    break;
                }
                if (hasCorresponding) {
                    for (Map.Entry<String, Object> entry : ((ComposeNode)correspondingNodes.get((Object)node1)).styleProperties.entrySet()) {
                        oldValue = node1.styleProperties.get(entry.getKey());
                        if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                        plan2 = new UpdatePlan(i - shift, UpdatePlan.ActionType.UPDATE_PROP);
                        plan2.stylePropertyName = entry.getKey();
                        plan2.stylePropertyOverride = entry.getValue();
                        updatePlans.add(plan2);
                    }
                } else {
                    plan = new UpdatePlan(i - shift, UpdatePlan.ActionType.REMOVE);
                    oldRoot.children.remove(i);
                    updatePlans.add(plan);
                    ++shift;
                }
            } else {
                hasCorresponding = false;
                for (int j = 0; j < newRoot.children.size(); ++j) {
                    node2 = newRoot.children.get(j);
                    if (node2.children.isEmpty() || !node1.uiElementName.equals(node2.uiElementName) || !node1.getFinalKey().equals(node2.getFinalKey()) || !node2.styleProperties.keySet().containsAll(node1.styleProperties.keySet())) continue;
                    correspondingNodes.put(node1, node2);
                    hasCorresponding = true;
                    break;
                }
                if (hasCorresponding) {
                    updatePlans.add(new UpdatePlan(i - shift, UpdatePlan.ActionType.GOTO_NEXT_LAYER));
                    SnapshotTree.recursiveDiff(updatePlans, node1, (ComposeNode)correspondingNodes.get(node1));
                    updatePlans.add(new UpdatePlan(-1, UpdatePlan.ActionType.GOTO_PREV_LAYER));
                    for (Map.Entry<String, Object> entry : ((ComposeNode)correspondingNodes.get((Object)node1)).styleProperties.entrySet()) {
                        oldValue = node1.styleProperties.get(entry.getKey());
                        if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                        plan2 = new UpdatePlan(i - shift, UpdatePlan.ActionType.UPDATE_PROP);
                        plan2.stylePropertyName = entry.getKey();
                        plan2.stylePropertyOverride = entry.getValue();
                        updatePlans.add(plan2);
                    }
                } else {
                    plan = new UpdatePlan(i - shift, UpdatePlan.ActionType.REMOVE);
                    oldRoot.children.remove(i);
                    updatePlans.add(plan);
                    ++shift;
                }
            }
            ++i;
        }
        for (i = 0; i < newRoot.children.size(); ++i) {
            ComposeNode node = newRoot.children.get(i);
            if (correspondingNodes.containsValue(node)) continue;
            UpdatePlan plan = new UpdatePlan(i, UpdatePlan.ActionType.ADD);
            plan.newElementName = node.uiElementName;
            plan.newStyleProperties = node.styleProperties;
            oldRoot.children.add(i, new ComposeNode("PLACEHOLDER", oldRoot, -1));
            updatePlans.add(plan);
            if (node.children.isEmpty()) continue;
            updatePlans.add(new UpdatePlan(i, UpdatePlan.ActionType.GOTO_NEXT_LAYER));
            SnapshotTree.recursiveAddAll(updatePlans, node);
            updatePlans.add(new UpdatePlan(-1, UpdatePlan.ActionType.GOTO_PREV_LAYER));
        }
        HashMap<Integer, Integer> perm = new HashMap<Integer, Integer>();
        for (Map.Entry entry : correspondingNodes.entrySet()) {
            int to;
            int from = oldRoot.children.indexOf(entry.getKey());
            if (from == (to = newRoot.children.indexOf(entry.getValue()))) continue;
            perm.put(from, to);
        }
        if (!perm.isEmpty()) {
            SnapshotTree.swaps(updatePlans, oldRoot.children, perm);
        }
    }

    private static void recursiveAddAll(List<UpdatePlan> updatePlans, ComposeNode root) {
        for (int i = 0; i < root.children.size(); ++i) {
            ComposeNode node = root.children.get(i);
            UpdatePlan plan = new UpdatePlan(i, UpdatePlan.ActionType.ADD);
            plan.newElementName = node.uiElementName;
            plan.newStyleProperties = node.styleProperties;
            updatePlans.add(plan);
            if (node.children.isEmpty()) continue;
            updatePlans.add(new UpdatePlan(i, UpdatePlan.ActionType.GOTO_NEXT_LAYER));
            SnapshotTree.recursiveAddAll(updatePlans, node);
            updatePlans.add(new UpdatePlan(-1, UpdatePlan.ActionType.GOTO_PREV_LAYER));
        }
    }

    public List<UpdatePlan> diff(SnapshotTree newSnapshot) {
        ArrayList<UpdatePlan> updatePlans = new ArrayList<UpdatePlan>();
        SnapshotTree.recursiveDiff(updatePlans, this.rootNode, newSnapshot.rootNode);
        return updatePlans;
    }

    public List<UpdatePlan> addAll() {
        ArrayList<UpdatePlan> updatePlans = new ArrayList<UpdatePlan>();
        SnapshotTree.recursiveAddAll(updatePlans, this.rootNode);
        return updatePlans;
    }
}

