/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render;

import com.tttsaurus.ingameinfo.common.core.render.IGlDisposable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public final class GlResourceManager {
    private static final List<IGlDisposable> disposables = new CopyOnWriteArrayList<IGlDisposable>();

    public static void addDisposable(IGlDisposable disposable) {
        disposables.add(disposable);
    }

    public static void removeDisposable(IGlDisposable disposable) {
        disposables.remove(disposable);
    }

    public static void disposeAll(Logger logger) {
        for (IGlDisposable disposable : disposables) {
            logger.info("Disposing " + disposable.getClass().getSimpleName());
            disposable.dispose();
            GlResourceManager.checkGLError(logger);
        }
    }

    private static void checkGLError(Logger logger) {
        int error;
        while ((error = GL11.glGetError()) != 0) {
            logger.warn("OpenGL Error: " + GlResourceManager.getErrorString(error));
        }
    }

    private static String getErrorString(int error) {
        String string;
        switch (error) {
            case 1280: {
                string = "GL_INVALID_ENUM";
                break;
            }
            case 1281: {
                string = "GL_INVALID_VALUE";
                break;
            }
            case 1282: {
                string = "GL_INVALID_OPERATION";
                break;
            }
            case 1283: {
                string = "GL_STACK_OVERFLOW";
                break;
            }
            case 1284: {
                string = "GL_STACK_UNDERFLOW";
                break;
            }
            case 1285: {
                string = "GL_OUT_OF_MEMORY";
                break;
            }
            default: {
                string = "Unknown Error (code: " + error + ")";
            }
        }
        return string;
    }
}

