/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render.shader.uniform;

import com.tttsaurus.ingameinfo.common.core.render.shader.uniform.UniformTypeKind;
import com.tttsaurus.ingameinfo.common.core.render.shader.uniform.Variant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UniformType {
    protected static final UniformType UNKNOWN = new UniformType("NO_SYMBOL", UniformTypeKind.UNKNOWN);
    protected static final UniformType ARRAY = new UniformType("NO_SYMBOL", UniformTypeKind.ARRAY);
    public static final String SYMBOL_FLOAT = "float";
    public static final String SYMBOL_DOUBLE = "double";
    public static final String SYMBOL_INT = "int";
    public static final String SYMBOL_UINT = "unit";
    public static final String SYMBOL_BOOL = "bool";
    public static final String SYMBOL_VEC2 = "vec2";
    public static final String SYMBOL_VEC3 = "vec3";
    public static final String SYMBOL_VEC4 = "vec4";
    public static final String SYMBOL_MAT2 = "mat2";
    public static final String SYMBOL_MAT3 = "mat3";
    public static final String SYMBOL_MAT4 = "mat4";
    public static final String SYMBOL_SAMPLER_1D = "sampler1D";
    public static final String SYMBOL_SAMPLER_2D = "sampler2D";
    public static final String SYMBOL_SAMPLER_3D = "sampler3D";
    public static final String SYMBOL_SAMPLER_CUBE = "samplerCube";
    public static final String SYMBOL_SAMPLER_2D_ARRAY = "sampler2DArray";
    public static final String SYMBOL_SAMPLER_CUBE_ARRAY = "samplerCubeArray";
    public static final String SYMBOL_SAMPLER_1D_SHADOW = "sampler1DShadow";
    public static final String SYMBOL_SAMPLER_2D_SHADOW = "sampler2DShadow";
    public static final String SYMBOL_SAMPLER_CUBE_SHADOW = "samplerCubeShadow";
    public static final String SYMBOL_SAMPLER_2D_MS = "sampler2DMS";
    public static final String SYMBOL_SAMPLER_2D_ARRAY_SHADOW = "sampler2DArrayShadow";
    public static final String SYMBOL_ATOMIC_UINT = "atomic_uint";
    public static final String SYMBOL_IMAGE_2D = "image2D";
    public static final String SYMBOL_IMAGE_3D = "image3D";
    public static final String SYMBOL_IMAGE_2D_ARRAY = "image2DArray";
    public static final String SYMBOL_IMAGE_CUBE = "imageCube";
    public static final String SYMBOL_IMAGE_2D_ARRAY_SHADOW = "image2DArrayShadow";
    protected static final List<UniformType> TYPE_PRESET = new ArrayList<UniformType>(Arrays.asList(new UniformType("float", UniformTypeKind.SCALAR), new UniformType("double", UniformTypeKind.SCALAR), new UniformType("int", UniformTypeKind.SCALAR), new UniformType("unit", UniformTypeKind.SCALAR), new UniformType("bool", UniformTypeKind.SCALAR), new UniformType("vec2", UniformTypeKind.VECTOR), new UniformType("vec3", UniformTypeKind.VECTOR), new UniformType("vec4", UniformTypeKind.VECTOR), new UniformType("mat2", UniformTypeKind.MATRIX), new UniformType("mat3", UniformTypeKind.MATRIX), new UniformType("mat4", UniformTypeKind.MATRIX), new UniformType("sampler1D", UniformTypeKind.SAMPLER), new UniformType("sampler2D", UniformTypeKind.SAMPLER), new UniformType("sampler3D", UniformTypeKind.SAMPLER), new UniformType("samplerCube", UniformTypeKind.SAMPLER), new UniformType("sampler2DArray", UniformTypeKind.SAMPLER), new UniformType("samplerCubeArray", UniformTypeKind.SAMPLER), new UniformType("sampler1DShadow", UniformTypeKind.SAMPLER), new UniformType("sampler2DShadow", UniformTypeKind.SAMPLER), new UniformType("samplerCubeShadow", UniformTypeKind.SAMPLER), new UniformType("sampler2DMS", UniformTypeKind.SAMPLER), new UniformType("sampler2DArrayShadow", UniformTypeKind.SAMPLER), new UniformType("atomic_uint", UniformTypeKind.ATOMIC_COUNTER), new UniformType("image2D", UniformTypeKind.IMAGE), new UniformType("image3D", UniformTypeKind.IMAGE), new UniformType("image2DArray", UniformTypeKind.IMAGE), new UniformType("imageCube", UniformTypeKind.IMAGE), new UniformType("image2DArrayShadow", UniformTypeKind.IMAGE)));
    private String symbol;
    private UniformTypeKind kind;
    private Variant variant = Variant.DEFAULT;
    private UniformType subType = null;
    private int arrayLength = 0;

    protected UniformType(String symbol, UniformTypeKind kind) {
        this.symbol = symbol;
        this.kind = kind;
    }

    protected UniformType setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public String getSymbol() {
        return this.symbol;
    }

    protected UniformType setKind(UniformTypeKind kind) {
        this.kind = kind;
        return this;
    }

    public UniformTypeKind getKind() {
        return this.kind;
    }

    protected UniformType setVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    public Variant getVariant() {
        return this.variant;
    }

    protected UniformType setSubType(UniformType subType) {
        this.subType = subType;
        return this;
    }

    public UniformType getSubType() {
        return this.subType;
    }

    protected UniformType setArrayLength(int arrayLength) {
        this.arrayLength = arrayLength;
        return this;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public UniformType deepClone() {
        UniformType cloned = new UniformType(this.symbol, this.kind);
        cloned.variant = this.variant;
        cloned.arrayLength = this.arrayLength;
        cloned.subType = this.subType == null ? null : this.subType.deepClone();
        return cloned;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.variant.getPrefix()).append(this.symbol);
        UniformType temp = this;
        if (temp.kind == UniformTypeKind.ARRAY && temp.subType != null) {
            builder.append("[").append(temp.arrayLength).append("]");
            temp = temp.subType;
        }
        builder.append(" (").append(temp.kind.toString()).append(")");
        return builder.toString();
    }
}

