/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render.text;

import com.tttsaurus.ingameinfo.common.core.commonutils.GhostableItem;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.text.FormattedTextParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public final class FormattedText {
    private static final float BAKING_TEXT_SIZE = 1.0f;
    public final List<BakedComponent> bakedComponents = new ArrayList<BakedComponent>();
    public final float width;
    public final float height;

    private FormattedText(String text) {
        if (text.isEmpty()) {
            this.width = 0.0f;
            this.height = RenderUtils.simulateTextHeight(1.0f);
            return;
        }
        List<FormattedTextParser.FlattenedToken> flattenedTokens = FormattedTextParser.flattenize(FormattedTextParser.tokenize(text));
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        float height = RenderUtils.simulateTextHeight(1.0f);
        StringBuilder sectionBuilder = new StringBuilder();
        boolean addTextSection = false;
        for (FormattedTextParser.FlattenedToken token : flattenedTokens) {
            String section;
            if (token.outputType == FormattedTextParser.FlattenedToken.OutputType.STRING) {
                for (FormattedTextParser.TokenType type : token.types) {
                    sectionBuilder.append(type.controlArg);
                }
                sectionBuilder.append(token.outputString);
                sectionBuilder.append(TextFormatting.RESET.toString());
                addTextSection = true;
                continue;
            }
            if (token.outputType == FormattedTextParser.FlattenedToken.OutputType.ITEM) {
                if (addTextSection) {
                    section = sectionBuilder.toString();
                    this.bakedComponents.add(new BakedComponent(x, y, section));
                    x += RenderUtils.simulateTextWidth(section, 1.0f);
                    sectionBuilder = new StringBuilder();
                    addTextSection = false;
                }
                this.bakedComponents.add(new BakedComponent(x, y, token.outputItem));
                width = Math.max(width, x += RenderUtils.simulateTextHeight(1.0f));
                continue;
            }
            if (token.outputType != FormattedTextParser.FlattenedToken.OutputType.LINE_BREAK) continue;
            if (addTextSection) {
                section = sectionBuilder.toString();
                this.bakedComponents.add(new BakedComponent(x, y, section));
                sectionBuilder = new StringBuilder();
                addTextSection = false;
                width = Math.max(width, x += RenderUtils.simulateTextWidth(section, 1.0f));
            }
            x = 0.0f;
            height = Math.max(height, (y += RenderUtils.simulateTextHeight(1.0f)) + RenderUtils.simulateTextHeight(1.0f));
        }
        if (addTextSection) {
            String section = sectionBuilder.toString();
            this.bakedComponents.add(new BakedComponent(x, y, section));
            width = Math.max(width, x += RenderUtils.simulateTextWidth(section, 1.0f));
        }
        this.width = width;
        this.height = height;
    }

    public static class BakedComponent {
        public final float x;
        public final float y;
        public final Type type;
        public final String text;
        public final GhostableItem item;

        public BakedComponent(float x, float y, String text) {
            this.x = x;
            this.y = y;
            this.type = Type.STRING;
            this.text = text;
            this.item = null;
        }

        public BakedComponent(float x, float y, GhostableItem item) {
            this.x = x;
            this.y = y;
            this.type = Type.ITEM;
            this.text = null;
            this.item = item;
        }

        public static enum Type {
            STRING,
            ITEM;

        }
    }
}

