/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render.text;

import com.tttsaurus.ingameinfo.common.core.commonutils.GhostableItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public final class FormattedTextParser {
    @Nullable
    private static TokenType getTokenType(String indicator) {
        for (TokenType type : TokenType.values()) {
            if (!type.indicator.equals(indicator) || type == TokenType.RAW) continue;
            return type;
        }
        return null;
    }

    private static int tokenizeNested(String text, int startIndex, List<NestedToken> tokens, AtomicBoolean abortFlag) {
        int index0;
        if (startIndex + 1 >= text.length()) {
            return startIndex;
        }
        int index1 = index0 = startIndex + 1;
        char c = text.charAt(index1);
        while (index1 + 1 < text.length() && c != '[') {
            c = text.charAt(++index1);
        }
        if (index1 + 1 >= text.length()) {
            abortFlag.set(true);
            return -1;
        }
        String tokenIndicator = text.substring(index0, index1);
        TokenType tokenType = FormattedTextParser.getTokenType(tokenIndicator);
        if (tokenType == null) {
            abortFlag.set(true);
            return -1;
        }
        int level = 1;
        index1 = index0 = index1 + 1;
        c = text.charAt(index1);
        while (true) {
            int indexNow;
            boolean nextLevel = false;
            if (c == '@' && (indexNow = index1 + 1) < text.length()) {
                char cNow = text.charAt(indexNow);
                while (indexNow + 1 < text.length() && cNow != '[') {
                    cNow = text.charAt(++indexNow);
                }
                if (FormattedTextParser.getTokenType(text.substring(index1 + 1, indexNow)) != null) {
                    nextLevel = true;
                } else {
                    abortFlag.set(true);
                    return -1;
                }
            }
            if (nextLevel) {
                ++level;
            }
            if (c == ']') {
                --level;
            }
            if (level == 0 || index1 + 1 >= text.length()) break;
            c = text.charAt(++index1);
        }
        if (level != 0) {
            abortFlag.set(true);
            return -1;
        }
        String nestedContent = text.substring(index0, index1);
        if (nestedContent.isEmpty()) {
            tokens.add(new NestedToken(tokenType, new ArrayList<NestedToken>()));
        } else {
            tokens.add(new NestedToken(tokenType, FormattedTextParser.tokenize(nestedContent)));
        }
        return index1 + 1;
    }

    protected static List<NestedToken> tokenize(String text) {
        if (text.isEmpty()) {
            return new ArrayList<NestedToken>();
        }
        if (text.length() == 1) {
            return Collections.singletonList(new NestedToken(text));
        }
        ArrayList<NestedToken> tokens = new ArrayList<NestedToken>();
        int index = 0;
        while (index + 1 < text.length()) {
            int index0;
            int index1 = index0 = index;
            char c = text.charAt(index1);
            while (index1 + 1 < text.length() && c != '@') {
                c = text.charAt(++index1);
            }
            if (index1 + 1 >= text.length()) {
                tokens.add(new NestedToken(text.substring(index0)));
                break;
            }
            tokens.add(new NestedToken(text.substring(index0, index1)));
            AtomicBoolean abortFlag = new AtomicBoolean(false);
            index = FormattedTextParser.tokenizeNested(text, index1, tokens, abortFlag);
            if (abortFlag.get()) break;
            if (index + 1 != text.length()) continue;
            tokens.add(new NestedToken(text.substring(index)));
        }
        return tokens;
    }

    private static List<FlattenedToken> flattenizeNested(NestedToken token) {
        if (token.type == TokenType.RAW) {
            if (token.argString.isEmpty()) {
                return new ArrayList<FlattenedToken>();
            }
            return Collections.singletonList(FlattenedToken.stringOutput(token.argString));
        }
        if (token.type == TokenType.I18N) {
            if (token.argTokens == null || token.argTokens.isEmpty()) {
                return new ArrayList<FlattenedToken>();
            }
            if (token.argTokens.get((int)0).type != TokenType.RAW) {
                return new ArrayList<FlattenedToken>();
            }
            return Collections.singletonList(FlattenedToken.stringOutput(I18n.func_135052_a((String)token.argTokens.get((int)0).argString, (Object[])new Object[0])));
        }
        if (token.type == TokenType.ITEM) {
            if (token.argTokens == null || token.argTokens.isEmpty()) {
                return Collections.singletonList(FlattenedToken.itemOutput(new GhostableItem("")));
            }
            if (token.argTokens.get((int)0).type != TokenType.RAW) {
                return Collections.singletonList(FlattenedToken.itemOutput(new GhostableItem("")));
            }
            GhostableItem item = new GhostableItem(token.argTokens.get((int)0).argString);
            item.abortNextTime();
            return Collections.singletonList(FlattenedToken.itemOutput(item));
        }
        if (token.type == TokenType.LINE_BREAK) {
            return Collections.singletonList(FlattenedToken.lineBreakOutput());
        }
        ArrayList<FlattenedToken> flattenedTokens = new ArrayList<FlattenedToken>();
        if (token.argTokens != null && !token.argTokens.isEmpty()) {
            for (NestedToken child : token.argTokens) {
                List<FlattenedToken> flattenedChildren = FormattedTextParser.flattenizeNested(child);
                for (FlattenedToken flattenedChild : flattenedChildren) {
                    flattenedChild.types.add(0, token.type);
                }
                flattenedTokens.addAll(flattenedChildren);
            }
        }
        return flattenedTokens;
    }

    protected static List<FlattenedToken> flattenize(List<NestedToken> tokens) {
        ArrayList<FlattenedToken> flattenedTokens = new ArrayList<FlattenedToken>();
        for (NestedToken nestedToken : tokens) {
            flattenedTokens.addAll(FormattedTextParser.flattenizeNested(nestedToken));
        }
        for (FlattenedToken flattenedToken : flattenedTokens) {
            flattenedToken.types.sort(Comparator.comparingInt(e -> {
                int index = TokenType.priorityLowest.indexOf(e);
                return index == -1 ? Integer.MAX_VALUE : index;
            }).reversed());
        }
        return flattenedTokens;
    }

    public static enum TokenType {
        RAW(""),
        BLACK("black", TextFormatting.BLACK.toString()),
        DARK_BLUE("dark_blue", TextFormatting.DARK_BLUE.toString()),
        DARK_GREEN("dark_green", TextFormatting.DARK_GREEN.toString()),
        DARK_AQUA("dark_aqua", TextFormatting.DARK_AQUA.toString()),
        DARK_RED("dark_red", TextFormatting.DARK_RED.toString()),
        DARK_PURPLE("dark_purple", TextFormatting.DARK_PURPLE.toString()),
        GOLD("gold", TextFormatting.GOLD.toString()),
        GRAY("gray", TextFormatting.GRAY.toString()),
        DARK_GRAY("dark_gray", TextFormatting.DARK_GRAY.toString()),
        BLUE("blue", TextFormatting.BLUE.toString()),
        GREEN("green", TextFormatting.GREEN.toString()),
        AQUA("aqua", TextFormatting.AQUA.toString()),
        RED("red", TextFormatting.RED.toString()),
        LIGHT_PURPLE("light_purple", TextFormatting.LIGHT_PURPLE.toString()),
        YELLOW("yellow", TextFormatting.YELLOW.toString()),
        WHITE("white", TextFormatting.WHITE.toString()),
        OBFUSCATED("obf", TextFormatting.OBFUSCATED.toString()),
        BOLD("bold", TextFormatting.BOLD.toString()),
        STRIKETHROUGH("strike_through", TextFormatting.STRIKETHROUGH.toString()),
        UNDERLINE("underline", TextFormatting.UNDERLINE.toString()),
        ITALIC("italic", TextFormatting.ITALIC.toString()),
        I18N("i18n"),
        ITEM("item"),
        LINE_BREAK("br");

        public static final List<TokenType> priorityLowest;
        public final String indicator;
        public final String controlArg;

        private TokenType(String indicator, String controlArg) {
            this.indicator = indicator;
            this.controlArg = controlArg;
        }

        private TokenType(String indicator) {
            this.indicator = indicator;
            this.controlArg = "";
        }

        static {
            priorityLowest = Arrays.asList(OBFUSCATED, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC);
        }
    }

    public static class NestedToken {
        public final TokenType type;
        public final String argString;
        public final List<NestedToken> argTokens;

        public NestedToken(String argString) {
            this.type = TokenType.RAW;
            this.argString = argString;
            this.argTokens = null;
        }

        public NestedToken(TokenType type, List<NestedToken> argTokens) {
            this.type = type;
            this.argTokens = argTokens;
            this.argString = null;
        }

        public String toString() {
            return this.recursiveToString(0);
        }

        private String recursiveToString(int indent) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                builder.append("  ");
            }
            String pad = builder.toString();
            builder = new StringBuilder();
            builder.append(pad).append("Token(").append((Object)this.type);
            if (this.type == TokenType.RAW) {
                builder.append(", value=\"").append(this.argString).append("\"");
            } else if (this.argTokens != null && !this.argTokens.isEmpty()) {
                builder.append(", children=[\n");
                for (NestedToken child : this.argTokens) {
                    builder.append(child.recursiveToString(indent + 1)).append("\n");
                }
                builder.append(pad).append("]");
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class FlattenedToken {
        public final OutputType outputType;
        public final String outputString;
        public final GhostableItem outputItem;
        public final List<TokenType> types;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.types.size(); ++i) {
                builder.append(this.types.get(i).toString());
                if (i == this.types.size() - 1) continue;
                builder.append(" -> ");
            }
            String output = "";
            if (this.outputType == OutputType.STRING) {
                output = this.outputString;
            } else if (this.outputType == OutputType.ITEM) {
                output = this.outputItem.toString();
            } else if (this.outputType == OutputType.LINE_BREAK) {
                output = OutputType.LINE_BREAK.toString();
            }
            return "FlattenedToken(types=" + builder.toString() + ", output=" + output + ')';
        }

        private FlattenedToken(OutputType outputType, String outputString, GhostableItem outputItem) {
            this.outputType = outputType;
            this.outputString = outputString;
            this.outputItem = outputItem;
            this.types = new ArrayList<TokenType>();
        }

        public static FlattenedToken stringOutput(String output) {
            return new FlattenedToken(OutputType.STRING, output, null);
        }

        public static FlattenedToken itemOutput(GhostableItem output) {
            return new FlattenedToken(OutputType.ITEM, null, output);
        }

        public static FlattenedToken lineBreakOutput() {
            return new FlattenedToken(OutputType.LINE_BREAK, null, null);
        }

        public static enum OutputType {
            STRING,
            ITEM,
            LINE_BREAK;

        }
    }
}

