/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render.texture;

import com.tttsaurus.ingameinfo.common.core.render.CommonBuffers;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.texture.ITexture2D;
import com.tttsaurus.ingameinfo.common.core.render.texture.ImagePrefab;
import com.tttsaurus.ingameinfo.common.core.render.texture.McTextureWrapper;
import com.tttsaurus.ingameinfo.common.core.render.texture.Texture2D;
import com.tttsaurus.ingameinfo.common.core.render.texture.TextureSliced2D;
import com.tttsaurus.ingameinfo.common.core.render.texture.param.FilterMode;
import com.tttsaurus.ingameinfo.common.core.render.texture.param.WrapMode;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public final class TextureHelper {
    @Nullable
    public static BufferedImage getBufferedImageFromRl(ResourceLocation rl) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(rl);
            InputStream inputStream = resource.func_110527_b();
            return ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setTextureParams(ITexture2D tex, FilterMode filterModeMin, FilterMode filterModeMag, WrapMode wrapModeS, WrapMode wrapModeT) {
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        int textureID = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glBindTexture((int)3553, (int)tex.getGlTextureID());
        GL11.glTexParameteri((int)3553, (int)10241, (int)filterModeMin.glValue);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filterModeMag.glValue);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapModeS.glValue);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapModeT.glValue);
        GlStateManager.func_179144_i((int)textureID);
    }

    @Nullable
    public static ImagePrefab tryWrapToImagePrefab(ITexture2D tex) {
        ImagePrefab imagePrefab = null;
        if (tex instanceof Texture2D) {
            Texture2D texture2D = (Texture2D)tex;
            imagePrefab = new ImagePrefab(texture2D);
        } else if (tex instanceof TextureSliced2D) {
            TextureSliced2D textureSliced2D = (TextureSliced2D)tex;
            imagePrefab = new ImagePrefab(textureSliced2D);
        }
        return imagePrefab;
    }

    @Nullable
    public static ITexture2D loadTextureFromRl(ResourceLocation rl) {
        TextureAtlasSprite mcSprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(rl.toString());
        if (mcSprite != null) {
            return new TextureSliced2D(mcSprite.func_130010_a(), mcSprite.func_110967_i(), mcSprite.func_94211_a(), mcSprite.func_94216_b(), Minecraft.func_71410_x().func_147117_R().func_110552_b(), mcSprite.func_94209_e(), mcSprite.func_94212_f(), mcSprite.func_94206_g(), mcSprite.func_94210_h());
        }
        BufferedImage image = TextureHelper.getBufferedImageFromRl(rl);
        if (image == null) {
            return null;
        }
        ITextureObject mcTex = Minecraft.func_71410_x().func_110434_K().func_110581_b(rl);
        if (mcTex != null) {
            return new Texture2D(image.getWidth(), image.getHeight(), mcTex.func_110552_b());
        }
        Texture2D texture2D = RenderUtils.createTexture2D(image);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)new McTextureWrapper(texture2D));
        return texture2D;
    }
}

