/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.appcommunication.spotify;

import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyOAuthUtils;
import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyUserInfo;
import com.tttsaurus.ingameinfo.common.impl.igievent.EventCenter;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class SpotifyCommandHandler {
    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        String message = event.getMessage().func_150260_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        String prefix = "<" + player.func_70005_c_() + "> ";
        if (!message.startsWith(prefix)) {
            return;
        }
        if ((message = message.substring(prefix.length()).toLowerCase(Locale.ROOT)).equals("#spotify-oauth")) {
            event.setCanceled(true);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + message));
            String authUrl = SpotifyOAuthUtils.generateAuthURL();
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Visit the auth link below to authorize:"));
            player.func_145747_a((ITextComponent)new TextComponentString(""));
            TextComponentString linkText = new TextComponentString("Auth Link Here");
            linkText.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, authUrl)).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
            player.func_145747_a((ITextComponent)linkText);
            player.func_145747_a((ITextComponent)new TextComponentString(""));
            try {
                SpotifyOAuthUtils.startCodeListeningServer();
            }
            catch (Exception exception) {}
        } else if (message.startsWith("#spotify-oauth-code")) {
            event.setCanceled(true);
            String[] args = message.split(" ");
            if (args.length == 2) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + message));
                String authorizationCode = args[1];
                try {
                    SpotifyUserInfo.token = SpotifyOAuthUtils.getToken(authorizationCode);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Successfully got the tokens!"));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Access Token:"));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + SpotifyUserInfo.token.accessToken));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Refresh Token:"));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + SpotifyUserInfo.token.refreshToken));
                }
                catch (Exception e) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Exception: " + e.getMessage()));
                }
            }
        } else if (message.equals("#spotify-gui-edit")) {
            event.setCanceled(true);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + message));
            EventCenter.spotifyOverlayEditEvent.trigger(new Object[0]);
        } else if (message.startsWith("#spotify-gui")) {
            String param;
            event.setCanceled(true);
            String[] args = message.split(" ");
            if (args.length == 2 && ((param = args[1]).equals("true") || param.equals("false"))) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + message));
                boolean flag = param.equals("true");
                EventCenter.spotifyOverlayEvent.trigger(flag);
            }
        } else if (message.equals("#spotify-refresh-token")) {
            event.setCanceled(true);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + message));
            if (SpotifyUserInfo.token.refreshToken.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " The refresh token is empty."));
                return;
            }
            try {
                SpotifyOAuthUtils.refreshAccessToken(SpotifyUserInfo.token);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Successfully refreshed the access token!"));
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Access Token:"));
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + SpotifyUserInfo.token.accessToken));
            }
            catch (Exception e) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Exception: " + e.getMessage()));
            }
        }
    }
}

