/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui;

import com.tttsaurus.ingameinfo.InGameInfoReborn;
import com.tttsaurus.ingameinfo.common.core.commonutils.RlReaderUtils;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLifecycleProvider;
import com.tttsaurus.ingameinfo.common.core.render.CommonBuffers;
import com.tttsaurus.ingameinfo.common.core.render.GlResourceManager;
import com.tttsaurus.ingameinfo.common.core.render.IGlDisposable;
import com.tttsaurus.ingameinfo.common.core.render.RenderHints;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.shader.Shader;
import com.tttsaurus.ingameinfo.common.core.render.shader.ShaderLoadingUtils;
import com.tttsaurus.ingameinfo.common.core.render.shader.ShaderProgram;
import com.tttsaurus.ingameinfo.common.impl.igievent.EventCenter;
import com.tttsaurus.ingameinfo.common.impl.network.IgiNetwork;
import com.tttsaurus.ingameinfo.config.IgiDefaultLifecycleProviderConfig;
import java.io.RandomAccessFile;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.time.StopWatch;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public final class DefaultLifecycleProvider
extends GuiLifecycleProvider {
    private final StopWatch stopwatch_FixedUpdate = new StopWatch();
    private int estimatedFps_FixedUpdate = 0;
    private double deltaTime_FixedUpdate = 0.0;
    private double excessTime_FixedUpdate = 0.0;
    private final StopWatch stopwatch_RenderUpdate = new StopWatch();
    private int estimatedFps_RenderUpdate = 0;
    private double excessTime_RenderUpdate = 0.0;
    private int estimatedUnlimitedFps = 1;
    private float estimatedFboRefreshRate = 0.0f;
    private float renderUpdateAlpha = 0.0f;
    private boolean enableFbo = true;
    private boolean refreshFbo = true;
    private Framebuffer fbo = null;
    private Framebuffer shaderFbo = null;
    private boolean enableMultisampleOnFbo = true;
    private Framebuffer resolvedFbo = null;
    private boolean enableShader = true;
    private ShaderProgram shaderProgram = null;
    private int texUnit1TextureID;
    private boolean uniformsPassed = false;
    private boolean renderTimeDebug = false;
    private final StopWatch cpuTimeStopwatch = new StopWatch();
    private final long[] cpuTimeNanoFor50Frames = new long[50];
    private final long[] gpuTimeNanoFor50Frames = new long[50];
    private int timeNanoArrayIndex = 0;
    private RandomAccessFile renderTimeDebugFile = null;
    private String lastBiomeRegistryName = "";
    private double timer = 0.5;
    private int textureID = 0;
    private float r = 0.0f;
    private float g = 0.0f;
    private float b = 0.0f;
    private float a = 0.0f;
    private boolean blend = false;
    private boolean lighting = false;
    private boolean texture2D = false;
    private boolean alphaTest = false;
    private int shadeModel = 0;
    private boolean depthTest = false;
    private boolean cullFace = false;
    private int blendSrcRgb;
    private int blendDstRgb;
    private int blendSrcAlpha;
    private int blendDstAlpha;
    private int alphaFunc;
    private float alphaRef;

    public void setEnableFbo(boolean flag) {
        this.enableFbo = flag;
    }

    public void setEnableMultisampleOnFbo(boolean flag) {
        this.enableMultisampleOnFbo = flag;
    }

    public void setEnableShader(boolean flag) {
        this.enableShader = flag;
    }

    public void setRenderTimeDebug(boolean flag) {
        this.renderTimeDebug = flag;
    }

    private void triggerIgiEvents() {
        MinecraftServer server;
        String biomeRegistryName;
        Biome biome;
        ResourceLocation rl;
        EventCenter.igiGuiFpsEvent.trigger(this.estimatedFps_FixedUpdate, this.estimatedFps_RenderUpdate);
        EventCenter.igiGuiFboRefreshRateEvent.trigger(Float.valueOf(this.estimatedFboRefreshRate));
        EventCenter.gameFpsEvent.trigger(Minecraft.func_175610_ah());
        Runtime runtime = Runtime.getRuntime();
        EventCenter.gameMemoryEvent.trigger(runtime.totalMemory() - runtime.freeMemory(), runtime.totalMemory());
        EntityPlayerSP player = DefaultLifecycleProvider.MC.field_71439_g;
        if (player != null && (rl = (biome = player.field_70170_p.func_180494_b(player.func_180425_c())).getRegistryName()) != null && !(biomeRegistryName = rl.toString()).equals(this.lastBiomeRegistryName)) {
            this.lastBiomeRegistryName = biomeRegistryName;
            EventCenter.enterBiomeEvent.trigger(biome.func_185359_l(), biomeRegistryName);
        }
        if ((server = FMLCommonHandler.instance().getMinecraftServerInstance()) == null) {
            IgiNetwork.requestTpsMspt((xva$0, xva$1) -> EventCenter.gameTpsMsptEvent.trigger(xva$0, xva$1));
        } else {
            long[] tickTimes = server.field_71311_j;
            double averageTickTime = 0.0;
            for (long tickTime : tickTimes) {
                averageTickTime += (double)tickTime / 1000000.0;
            }
            int tps = (int)Math.min(1000.0 / (averageTickTime /= (double)tickTimes.length), 20.0);
            EventCenter.gameTpsMsptEvent.trigger(tps, averageTickTime);
        }
        EventCenter.triggerModCompatEvents();
    }

    @Override
    protected void fixedUpdate() {
        this.definedFixedUpdate(this.deltaTime_FixedUpdate);
        this.timer += this.deltaTime_FixedUpdate;
        if (this.timer >= 0.5) {
            this.timer -= 0.5;
            this.triggerIgiEvents();
        }
        if (this.timer >= 0.5) {
            this.timer %= 0.5;
        }
    }

    @Override
    protected void renderUpdate() {
        this.storeCommonGlStates();
        if (this.renderTimeDebug) {
            this.renderUpdateInternalDebug();
        } else {
            this.renderUpdateInternal();
        }
        this.restoreCommonGlStates();
    }

    private void renderUpdateInternal() {
        if (this.enableFbo) {
            if (this.enableShader) {
                this.compileShaders();
            }
            if (!this.refreshFbo) {
                if (this.enableShader) {
                    RenderUtils.renderFbo(this.resolution, this.shaderFbo, true);
                } else if (this.enableMultisampleOnFbo) {
                    RenderUtils.renderFbo(this.resolution, this.resolvedFbo, true);
                } else {
                    RenderUtils.renderFbo(this.resolution, this.fbo, true);
                }
                return;
            }
            this.refreshFbo = false;
            this.bindFbo();
        }
        this.definedRenderUpdate();
        if (this.enableFbo) {
            if (this.enableShader) {
                this.bindShaderFbo();
                this.activateShaders();
                RenderUtils.renderFbo(this.resolution, this.fbo, false);
                this.deactivateShaders();
                this.bindMcFbo();
                RenderUtils.renderFbo(this.resolution, this.shaderFbo, true);
            } else {
                if (this.enableMultisampleOnFbo) {
                    this.resolveMultisampledFbo();
                }
                this.bindMcFbo();
                if (this.enableMultisampleOnFbo) {
                    RenderUtils.renderFbo(this.resolution, this.resolvedFbo, true);
                } else {
                    RenderUtils.renderFbo(this.resolution, this.fbo, true);
                }
            }
        }
    }

    private void renderUpdateInternalDebug() {
        if (this.renderTimeDebugFile == null) {
            try {
                this.renderTimeDebugFile = new RandomAccessFile("ingameinfo_render_time.csv", "rw");
                this.renderTimeDebugFile.setLength(0L);
                this.renderTimeDebugFile.seek(0L);
                this.renderTimeDebugFile.write("Cpu Time Nano,Gpu Time Nano,Avg Cpu Time Nano,Avg Gpu Time Nano\n".getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int gpuTimeQueryID = GL15.glGenQueries();
        GL15.glBeginQuery((int)35007, (int)gpuTimeQueryID);
        this.cpuTimeStopwatch.reset();
        this.cpuTimeStopwatch.start();
        this.renderUpdateInternal();
        this.cpuTimeStopwatch.stop();
        GL15.glEndQuery((int)35007);
        CommonBuffers.INT_BUFFER_16.clear();
        GL15.glGetQueryObject((int)gpuTimeQueryID, (int)34918, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        long gpuTimeNano = CommonBuffers.INT_BUFFER_16.get(0);
        long cpuTimeNano = this.cpuTimeStopwatch.getNanoTime();
        if (this.timeNanoArrayIndex == 50) {
            int i;
            long avgCpuTimeNano = Arrays.stream(this.cpuTimeNanoFor50Frames).sum() / 50L;
            long avgGpuTimeNano = Arrays.stream(this.gpuTimeNanoFor50Frames).sum() / 50L;
            try {
                this.renderTimeDebugFile.write((this.cpuTimeNanoFor50Frames[this.timeNanoArrayIndex - 1] + "," + this.gpuTimeNanoFor50Frames[this.timeNanoArrayIndex - 1] + "," + avgCpuTimeNano + "," + avgGpuTimeNano + "\n").getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (i = 1; i < 50; ++i) {
                this.cpuTimeNanoFor50Frames[i - 1] = this.cpuTimeNanoFor50Frames[i];
            }
            this.cpuTimeNanoFor50Frames[this.timeNanoArrayIndex - 1] = cpuTimeNano;
            for (i = 1; i < 50; ++i) {
                this.gpuTimeNanoFor50Frames[i - 1] = this.gpuTimeNanoFor50Frames[i];
            }
            this.gpuTimeNanoFor50Frames[this.timeNanoArrayIndex - 1] = gpuTimeNano;
        } else {
            try {
                this.renderTimeDebugFile.write((cpuTimeNano + "," + gpuTimeNano + ",0,0\n").getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cpuTimeNanoFor50Frames[this.timeNanoArrayIndex] = cpuTimeNano;
            this.gpuTimeNanoFor50Frames[this.timeNanoArrayIndex] = gpuTimeNano;
            ++this.timeNanoArrayIndex;
        }
    }

    private void resolveMultisampledFbo() {
        if (this.resolvedFbo == null) {
            this.resolvedFbo = new Framebuffer(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d, true);
            this.resolvedFbo.field_147625_i[0] = 0.0f;
            this.resolvedFbo.field_147625_i[1] = 0.0f;
            this.resolvedFbo.field_147625_i[2] = 0.0f;
            this.resolvedFbo.field_147625_i[3] = 0.0f;
            this.resolvedFbo.enableStencil();
            this.resolvedFbo.func_147609_e();
            GlResourceManager.addDisposable((IGlDisposable)this.resolvedFbo);
        }
        if (this.resolvedFbo.field_147621_c != DefaultLifecycleProvider.MC.field_71443_c || this.resolvedFbo.field_147618_d != DefaultLifecycleProvider.MC.field_71440_d) {
            this.resolvedFbo.func_147613_a(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d);
            this.resolvedFbo.func_147609_e();
        }
        OpenGlHelper.func_153171_g((int)36008, (int)this.fbo.field_147616_f);
        OpenGlHelper.func_153171_g((int)36009, (int)this.resolvedFbo.field_147616_f);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.resolvedFbo.field_147621_c, (int)this.resolvedFbo.field_147618_d, (int)0, (int)0, (int)this.resolvedFbo.field_147621_c, (int)this.resolvedFbo.field_147618_d, (int)16384, (int)9728);
    }

    private void bindShaderFbo() {
        if (this.shaderFbo == null) {
            this.shaderFbo = new Framebuffer(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d, true);
            this.shaderFbo.field_147625_i[0] = 0.0f;
            this.shaderFbo.field_147625_i[1] = 0.0f;
            this.shaderFbo.field_147625_i[2] = 0.0f;
            this.shaderFbo.field_147625_i[3] = 0.0f;
            this.shaderFbo.enableStencil();
            this.shaderFbo.func_147610_a(true);
            GlResourceManager.addDisposable((IGlDisposable)this.shaderFbo);
        }
        if (this.shaderFbo.field_147621_c != DefaultLifecycleProvider.MC.field_71443_c || this.shaderFbo.field_147618_d != DefaultLifecycleProvider.MC.field_71440_d) {
            this.shaderFbo.func_147613_a(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d);
            this.shaderFbo.func_147610_a(true);
        } else {
            RenderHints.clearFboWithoutUnbind();
            this.shaderFbo.func_147614_f();
            RenderHints.clearFboWithUnbind();
        }
    }

    private void bindFbo() {
        if (this.fbo == null) {
            if (this.enableMultisampleOnFbo) {
                RenderHints.multisampleTexBind();
                RenderHints.multisampleFbo();
            }
            this.fbo = new Framebuffer(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d, true);
            this.fbo.field_147625_i[0] = 0.0f;
            this.fbo.field_147625_i[1] = 0.0f;
            this.fbo.field_147625_i[2] = 0.0f;
            this.fbo.field_147625_i[3] = 0.0f;
            this.fbo.enableStencil();
            if (this.enableMultisampleOnFbo) {
                RenderHints.defaultTexBind();
                RenderHints.defaultFbo();
            }
            this.fbo.func_147610_a(true);
            GlResourceManager.addDisposable((IGlDisposable)this.fbo);
        }
        if (this.fbo.field_147621_c != DefaultLifecycleProvider.MC.field_71443_c || this.fbo.field_147618_d != DefaultLifecycleProvider.MC.field_71440_d) {
            if (this.enableMultisampleOnFbo) {
                RenderHints.multisampleTexBind();
                RenderHints.multisampleFbo();
            }
            this.fbo.func_147613_a(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d);
            if (this.enableMultisampleOnFbo) {
                RenderHints.defaultTexBind();
                RenderHints.defaultFbo();
            }
            this.fbo.func_147610_a(true);
        } else {
            RenderHints.clearFboWithoutUnbind();
            this.fbo.func_147614_f();
            RenderHints.clearFboWithUnbind();
        }
    }

    private void bindMcFbo() {
        Framebuffer mcFbo = MC.func_147110_a();
        if (mcFbo.field_147621_c != DefaultLifecycleProvider.MC.field_71443_c || mcFbo.field_147618_d != DefaultLifecycleProvider.MC.field_71440_d) {
            mcFbo.func_147613_a(DefaultLifecycleProvider.MC.field_71443_c, DefaultLifecycleProvider.MC.field_71440_d);
        }
        mcFbo.func_147610_a(true);
    }

    private void compileShaders() {
        if (this.shaderProgram == null) {
            String rawFrag = RlReaderUtils.read("ingameinfo:shaders/post_processing_frag.glsl", true);
            StringBuilder rawFragBuilder = new StringBuilder();
            if (this.enableMultisampleOnFbo) {
                rawFragBuilder.append("#version 400 core\n").append("#define USE_MULTISAMPLE 1\n");
            } else {
                rawFragBuilder.append("#version 330 core\n").append("#define USE_MULTISAMPLE 0\n");
            }
            rawFragBuilder.append(rawFrag);
            Shader frag = new Shader("ingameinfo:shaders/post_processing_frag.glsl", rawFragBuilder.toString(), Shader.ShaderType.FRAGMENT);
            Shader vertex = ShaderLoadingUtils.load("ingameinfo:shaders/post_processing_vertex.glsl", Shader.ShaderType.VERTEX);
            this.shaderProgram = new ShaderProgram(frag, vertex);
            this.shaderProgram.setup();
            InGameInfoReborn.LOGGER.info(this.shaderProgram.getSetupDebugReport());
        }
    }

    private void activateShaders() {
        this.shaderProgram.use();
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)34016, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        int texUnit = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.INT_BUFFER_16.clear();
        GlStateManager.func_179138_g((int)33985);
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.texUnit1TextureID = CommonBuffers.INT_BUFFER_16.get(0);
        if (this.enableMultisampleOnFbo) {
            RenderHints.multisampleTexBind();
        }
        this.fbo.func_147612_c();
        if (this.enableMultisampleOnFbo) {
            RenderHints.defaultTexBind();
        }
        GlStateManager.func_179138_g((int)texUnit);
        if (!this.uniformsPassed) {
            this.uniformsPassed = true;
            this.shaderProgram.setUniform("screenTexture", 1);
            if (this.enableMultisampleOnFbo) {
                this.shaderProgram.setUniform("sampleNum", RenderHints.getHint_Framebuffer$FramebufferSampleNum());
            }
            this.shaderProgram.setUniform("enableAlpha", IgiDefaultLifecycleProviderConfig.ENABLE_PP_ALPHA);
            this.shaderProgram.setUniform("targetAlpha", Float.valueOf(IgiDefaultLifecycleProviderConfig.PP_ALPHA));
        }
    }

    private void deactivateShaders() {
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)34016, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        int texUnit = CommonBuffers.INT_BUFFER_16.get(0);
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179144_i((int)this.texUnit1TextureID);
        GlStateManager.func_179138_g((int)texUnit);
        this.shaderProgram.unuse();
    }

    private void storeCommonGlStates() {
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.textureID = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.FLOAT_BUFFER_16.clear();
        GL11.glGetFloat((int)2816, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        this.r = CommonBuffers.FLOAT_BUFFER_16.get(0);
        this.g = CommonBuffers.FLOAT_BUFFER_16.get(1);
        this.b = CommonBuffers.FLOAT_BUFFER_16.get(2);
        this.a = CommonBuffers.FLOAT_BUFFER_16.get(3);
        this.blend = GL11.glIsEnabled((int)3042);
        this.lighting = GL11.glIsEnabled((int)2896);
        this.texture2D = GL11.glIsEnabled((int)3553);
        this.alphaTest = GL11.glIsEnabled((int)3008);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)2900, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.shadeModel = CommonBuffers.INT_BUFFER_16.get(0);
        this.depthTest = GL11.glIsEnabled((int)2929);
        this.cullFace = GL11.glIsEnabled((int)2884);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)32969, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.blendSrcRgb = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)32968, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.blendDstRgb = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)32971, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.blendSrcAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)32970, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.blendDstAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.INT_BUFFER_16.clear();
        GL11.glGetInteger((int)3009, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        this.alphaFunc = CommonBuffers.INT_BUFFER_16.get(0);
        CommonBuffers.FLOAT_BUFFER_16.clear();
        GL11.glGetFloat((int)3010, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        this.alphaRef = CommonBuffers.FLOAT_BUFFER_16.get(0);
    }

    private void restoreCommonGlStates() {
        GlStateManager.func_179092_a((int)this.alphaFunc, (float)this.alphaRef);
        GlStateManager.func_179120_a((int)this.blendSrcRgb, (int)this.blendDstRgb, (int)this.blendSrcAlpha, (int)this.blendDstAlpha);
        if (this.cullFace) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        if (this.depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179103_j((int)this.shadeModel);
        if (this.alphaTest) {
            GlStateManager.func_179141_d();
        } else {
            GlStateManager.func_179118_c();
        }
        if (this.texture2D) {
            GlStateManager.func_179098_w();
        } else {
            GlStateManager.func_179090_x();
        }
        if (this.lighting) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        if (this.blend) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179131_c((float)this.r, (float)this.g, (float)this.b, (float)this.a);
        GlStateManager.func_179144_i((int)this.textureID);
    }

    @Override
    protected boolean isUsingFramebuffer() {
        return this.enableFbo;
    }

    @Override
    protected boolean isUsingMultisampleFramebuffer() {
        return this.enableMultisampleOnFbo;
    }

    @Override
    public float getRenderLerpAlpha() {
        return this.renderUpdateAlpha;
    }

    @Override
    protected void timing() {
        double currentTime;
        if (!this.stopwatch_FixedUpdate.isStarted()) {
            this.stopwatch_FixedUpdate.start();
        }
        if ((currentTime = (double)this.stopwatch_FixedUpdate.getNanoTime() / 1.0E9) + this.excessTime_FixedUpdate >= this.timePerFrame_FixedUpdate) {
            this.stopwatch_FixedUpdate.stop();
            this.stopwatch_FixedUpdate.reset();
            this.stopwatch_FixedUpdate.start();
            this.deltaTime_FixedUpdate = currentTime;
            this.estimatedFps_FixedUpdate = ((int)(1.0 / (currentTime + this.excessTime_FixedUpdate)) + this.estimatedFps_FixedUpdate) / 2;
            this.reserveFixedUpdate();
            this.excessTime_FixedUpdate = currentTime + this.excessTime_FixedUpdate - this.timePerFrame_FixedUpdate;
        }
        if (this.excessTime_FixedUpdate >= this.timePerFrame_FixedUpdate) {
            this.excessTime_FixedUpdate %= this.timePerFrame_FixedUpdate;
        }
        if (this.enableFbo) {
            if (!this.stopwatch_RenderUpdate.isStarted()) {
                this.stopwatch_RenderUpdate.start();
                this.stopwatch_RenderUpdate.split();
            }
            currentTime = (double)this.stopwatch_RenderUpdate.getNanoTime() / 1.0E9;
            this.estimatedFboRefreshRate = (Math.min((float)this.estimatedFps_RenderUpdate / (float)this.estimatedUnlimitedFps, 1.0f) + this.estimatedFboRefreshRate) / 2.0f;
            double lastSplitTime = (double)this.stopwatch_RenderUpdate.getSplitNanoTime() / 1.0E9;
            this.stopwatch_RenderUpdate.split();
            if (currentTime - lastSplitTime > 0.0) {
                this.estimatedUnlimitedFps = ((int)(1.0 / (currentTime - lastSplitTime)) + this.estimatedUnlimitedFps) / 2;
            }
            if (currentTime + this.excessTime_RenderUpdate >= this.timePerFrame_RenderUpdate) {
                this.stopwatch_RenderUpdate.stop();
                this.stopwatch_RenderUpdate.reset();
                this.stopwatch_RenderUpdate.start();
                this.stopwatch_RenderUpdate.split();
                this.estimatedFps_RenderUpdate = ((int)(1.0 / (currentTime + this.excessTime_RenderUpdate)) + this.estimatedFps_RenderUpdate) / 2;
                this.refreshFbo = true;
                double fixedUpdateTime = (double)this.stopwatch_FixedUpdate.getNanoTime() / 1.0E9;
                this.renderUpdateAlpha = fixedUpdateTime + this.excessTime_FixedUpdate >= this.timePerFrame_FixedUpdate ? 1.0f : (float)((fixedUpdateTime + this.excessTime_FixedUpdate) / this.timePerFrame_FixedUpdate);
                this.excessTime_RenderUpdate = currentTime + this.excessTime_RenderUpdate - this.timePerFrame_RenderUpdate;
            }
            if (this.excessTime_RenderUpdate >= this.timePerFrame_RenderUpdate) {
                this.excessTime_RenderUpdate %= this.timePerFrame_RenderUpdate;
            }
        } else {
            double fixedUpdateTime = (double)this.stopwatch_FixedUpdate.getNanoTime() / 1.0E9;
            this.renderUpdateAlpha = fixedUpdateTime + this.excessTime_FixedUpdate >= this.timePerFrame_FixedUpdate ? 1.0f : (float)((fixedUpdateTime + this.excessTime_FixedUpdate) / this.timePerFrame_FixedUpdate);
        }
    }
}

