/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.animation.text.CharInfo;
import com.tttsaurus.ingameinfo.common.core.animation.text.ITextAnimDef;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpCenter;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpableProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.wrapped.DoubleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.AnimTextOp;
import java.util.Arrays;

@RegisterElement
public class AnimText
extends Element {
    @LerpTarget(value="charInfos")
    private final LerpableProperty<CharInfo[]> lerpableCharInfos = new LerpableProperty<CharInfo[]>(){

        @Override
        public CharInfo[] lerp(float percentage) {
            CharInfo[] out = new CharInfo[Math.min(((CharInfo[])this.prevValue).length, ((CharInfo[])this.currValue).length)];
            for (int i = 0; i < out.length; ++i) {
                CharInfo prevInfo = ((CharInfo[])this.prevValue)[i];
                CharInfo currInfo = ((CharInfo[])this.currValue)[i];
                out[i] = (CharInfo)currInfo.copy();
                out[i].x = LerpCenter.lerp(prevInfo.x, currInfo.x, percentage);
                out[i].y = LerpCenter.lerp(prevInfo.y, currInfo.y, percentage);
                out[i].scale = LerpCenter.lerp(prevInfo.scale, currInfo.scale, percentage);
            }
            return out;
        }
    };
    private CharInfo[] charInfos = new CharInfo[0];
    private final DoubleProperty timer = new DoubleProperty();
    @StyleProperty(setterCallbackPre="textAnimDefValidation")
    public ITextAnimDef animDef;
    @StyleProperty(setterCallbackPost="setTextCallback", setterCallbackPre="textValidation")
    public String text = "";
    @StyleProperty(setterCallbackPost="setScaleCallback", setterCallbackPre="scaleValidation")
    public float scale = 0.0f;
    @StyleProperty(setterCallbackPost="setColorCallback")
    public int color;
    @StyleProperty(setterCallbackPost="setShadowCallback")
    public boolean shadow;
    private boolean isShadowInit = false;

    @StylePropertyCallback
    public void textAnimDefValidation(ITextAnimDef value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void textValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setTextCallback() {
        char c;
        int i;
        int oldLength = this.charInfos.length;
        int length = this.text.length();
        float width = 0.0f;
        for (i = 0; i < oldLength; ++i) {
            c = this.text.charAt(i);
            this.charInfos[i].x = width;
            width += (float)RenderUtils.fontRenderer.func_78263_a(c) * this.charInfos[i].scale;
        }
        this.charInfos = Arrays.copyOf(this.charInfos, length);
        for (i = oldLength; i < length; ++i) {
            c = this.text.charAt(i);
            this.charInfos[i] = new CharInfo(width, 0.0f, this.scale, this.color, this.shadow);
            width += (float)RenderUtils.fontRenderer.func_78263_a(c) * this.scale;
        }
        this.requestReCalc();
    }

    @StylePropertyCallback
    public void scaleValidation(float value, CallbackInfo callbackInfo) {
        if (value < 0.0f) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setScaleCallback() {
        float width = 0.0f;
        for (int i = 0; i < this.charInfos.length; ++i) {
            char c = this.text.charAt(i);
            this.charInfos[i].x = width;
            this.charInfos[i].scale = this.scale;
            width += (float)RenderUtils.fontRenderer.func_78263_a(c) * this.charInfos[i].scale;
        }
        this.requestReCalc();
    }

    @StylePropertyCallback
    public void setColorCallback() {
        for (CharInfo info : this.charInfos) {
            info.color = this.color;
        }
    }

    @StylePropertyCallback
    public void setShadowCallback() {
        for (CharInfo info : this.charInfos) {
            info.shadow = this.shadow;
        }
        if (!this.isShadowInit) {
            this.isShadowInit = true;
        }
    }

    @Override
    public void calcWidthHeight() {
        this.rect.width = RenderUtils.simulateTextWidth(this.text, this.scale);
        this.rect.height = RenderUtils.simulateTextHeight(this.scale);
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
        if (this.timer.get() == null || (Double)this.timer.get() == Double.POSITIVE_INFINITY) {
            this.timer.set(0.0);
        }
        this.animDef.calcAnim(this.charInfos, this.timer, deltaTime);
        this.timer.set((Double)this.timer.get() + deltaTime);
    }

    @Override
    public void applyLogicTheme(ThemeConfig themeConfig) {
        super.applyLogicTheme(themeConfig);
        if (this.scale == 0.0f) {
            this.setStyleProperty("scale", Float.valueOf(themeConfig.animText.scale));
        }
        if (!this.isShadowInit) {
            this.isShadowInit = true;
            this.setStyleProperty("shadow", themeConfig.animText.shadow);
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        queue.enqueue(new AnimTextOp(this.text, this.rect.x, this.rect.y, this.color, this.lerpableCharInfos));
    }
}

