/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Sized;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpCenter;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpableProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.MaskEndOp;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.MaskStartOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.text.FormattedText;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.SlidingTextOp;

@RegisterElement
public class SlidingText
extends Sized {
    @LerpTarget(value="xShift")
    private final LerpableProperty<Float> lerpableXShift = new LerpableProperty<Float>(){

        @Override
        public Float lerp(float percentage) {
            if (((Float)this.currValue).floatValue() == 0.0f) {
                this.prevValue = Float.valueOf(0.0f);
            }
            return Float.valueOf(LerpCenter.lerp(((Float)this.prevValue).floatValue(), ((Float)this.currValue).floatValue(), percentage));
        }
    };
    private FormattedText formattedText = RenderUtils.bakeFormattedText("");
    private float xShift = 0.0f;
    private boolean needSliding;
    private float simulatedWidth;
    private float freezeTimer = 0.0f;
    private boolean onFreezeTiming = true;
    @StyleProperty(setterCallbackPre="nonNegativeFloatValidation")
    public float spareWidth = 10.0f;
    @StyleProperty(setterCallbackPre="nonNegativeFloatValidation")
    public float xShiftSpeed = 8.0f;
    @StyleProperty(setterCallbackPre="nonNegativeFloatValidation")
    public float freezeTime = 2.0f;
    @StyleProperty
    public boolean onDemandSliding = false;
    @StyleProperty(setterCallbackPost="setForwardSlidingCallback")
    public boolean forwardSliding = false;
    @StyleProperty(setterCallbackPost="setTextCallback", setterCallbackPre="textValidation")
    public String text = "";
    @StyleProperty(setterCallbackPost="setScaleCallback", setterCallbackPre="nonNegativeFloatValidation")
    public float scale = 0.0f;
    @StyleProperty
    public int color;
    @StyleProperty(setterCallbackPost="setShadowCallback")
    public boolean shadow;
    private boolean isShadowInit = false;

    @StylePropertyCallback
    public void setForwardSlidingCallback() {
        this.xShift = 0.0f;
        this.freezeTimer = 0.0f;
        this.onFreezeTiming = true;
    }

    @StylePropertyCallback
    public void textValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setTextCallback() {
        this.formattedText = RenderUtils.bakeFormattedText(this.text);
        this.simulatedWidth = this.formattedText.width * this.scale;
        this.needSliding = this.simulatedWidth > this.width;
        this.height = this.formattedText.height * this.scale;
        this.xShift = 0.0f;
        this.freezeTimer = 0.0f;
        this.onFreezeTiming = true;
        this.requestReCalc();
    }

    @StylePropertyCallback
    public void setScaleCallback() {
        this.simulatedWidth = this.formattedText.width * this.scale;
        this.needSliding = this.simulatedWidth > this.width;
        this.height = this.formattedText.height * this.scale;
        this.requestReCalc();
    }

    @StylePropertyCallback
    public void setShadowCallback() {
        if (!this.isShadowInit) {
            this.isShadowInit = true;
        }
    }

    @Override
    public void applyLogicTheme(ThemeConfig themeConfig) {
        super.applyLogicTheme(themeConfig);
        if (this.scale == 0.0f) {
            this.setStyleProperty("scale", Float.valueOf(themeConfig.slidingText.scale));
        }
        if (!this.isShadowInit) {
            this.isShadowInit = true;
            this.setStyleProperty("shadow", themeConfig.slidingText.shadow);
        }
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
        if (!(this.onDemandSliding && !this.needSliding || this.onFreezeTiming)) {
            this.xShift += (float)(deltaTime * (double)this.xShiftSpeed);
        }
        if (this.onFreezeTiming) {
            this.xShift = 0.0f;
            if (this.freezeTimer > this.freezeTime) {
                this.freezeTimer = 0.0f;
                this.onFreezeTiming = false;
            }
            this.freezeTimer += (float)deltaTime;
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        if (!this.onDemandSliding || this.needSliding) {
            queue.enqueue(new MaskStartOp(this.rect));
            if (this.forwardSliding) {
                if (this.rect.x + this.xShift < this.rect.x + this.rect.width) {
                    queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x, this.rect.y, this.lerpableXShift, true, this.scale, this.color, this.shadow));
                }
                if (this.xShift > this.spareWidth) {
                    if (this.rect.x - this.simulatedWidth - this.spareWidth + this.xShift >= this.rect.x) {
                        this.onFreezeTiming = true;
                        queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x, this.rect.y, this.scale, this.color, this.shadow));
                    } else {
                        queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x - this.simulatedWidth - this.spareWidth, this.rect.y, this.lerpableXShift, true, this.scale, this.color, this.shadow));
                    }
                }
            } else {
                if (this.rect.x - this.xShift > this.rect.x - this.simulatedWidth) {
                    queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x, this.rect.y, this.lerpableXShift, false, this.scale, this.color, this.shadow));
                }
                if (this.xShift > this.spareWidth + this.simulatedWidth - this.rect.width) {
                    if (this.rect.x + this.spareWidth + this.simulatedWidth - this.xShift <= this.rect.x) {
                        this.onFreezeTiming = true;
                        queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x, this.rect.y, this.scale, this.color, this.shadow));
                    } else {
                        queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x + this.spareWidth + this.simulatedWidth, this.rect.y, this.lerpableXShift, false, this.scale, this.color, this.shadow));
                    }
                }
            }
            queue.enqueue(new MaskEndOp());
        } else {
            queue.enqueue(new SlidingTextOp(this.formattedText, this.rect.x, this.rect.y, this.scale, this.color, this.shadow));
        }
    }
}

