/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.layout;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Alignment;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Skewness;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;

@RegisterElement
public class HorizontalGroup
extends ElementGroup {
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="skewnessValidation")
    public Skewness skewness = Skewness.NULL;

    @StylePropertyCallback
    public void skewnessValidation(Skewness value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @Override
    public void calcRenderPos(Rect contextRect) {
        Element element;
        int i;
        Element first;
        super.calcRenderPos(contextRect);
        if (this.elements.isEmpty()) {
            return;
        }
        if (this.pivot.vertical == 0.0f || this.pivot.vertical == 0.5f) {
            first = (Element)this.elements.get(0);
            first.rect.x += this.rect.x + first.padding.left;
            for (i = 1; i < this.elements.size(); ++i) {
                element = (Element)this.elements.get(i);
                Element prevElement = (Element)this.elements.get(i - 1);
                element.rect.x = prevElement.rect.x + prevElement.rect.width + prevElement.padding.right + element.padding.left;
            }
        }
        if (this.pivot.vertical == 1.0f) {
            first = (Element)this.elements.get(this.elements.size() - 1);
            first.rect.x += this.rect.x + this.rect.width - first.padding.right - first.rect.width;
            for (i = this.elements.size() - 1; i > 0; --i) {
                element = (Element)this.elements.get(i);
                Element nextElement = (Element)this.elements.get(i - 1);
                nextElement.rect.x = element.rect.x - element.padding.left - nextElement.padding.right - nextElement.rect.width;
            }
        }
        if (this.pivot.horizontal == 0.0f && this.skewness == Skewness.NULL || this.pivot.horizontal == 0.5f && this.skewness == Skewness.NULL || this.skewness == Skewness.LEFT) {
            for (Element element2 : this.elements) {
                if (element2.alignment == Alignment.NULL) {
                    element2.rect.y += this.rect.y + element2.padding.top;
                    continue;
                }
                element2.rect.y += this.rect.y + this.rect.height * element2.alignment.horizontal;
                if (element2.pivot.horizontal == 0.0f || element2.pivot.horizontal == 0.5f) {
                    element2.rect.y += element2.padding.top;
                }
                if (element2.pivot.horizontal != 1.0f && element2.pivot.horizontal != 0.5f) continue;
                element2.rect.y -= element2.padding.bottom;
            }
        }
        if (this.pivot.horizontal == 1.0f && this.skewness == Skewness.NULL || this.skewness == Skewness.RIGHT) {
            for (Element element3 : this.elements) {
                if (element3.alignment == Alignment.NULL) {
                    element3.rect.y += this.rect.y + this.rect.height - element3.padding.bottom - element3.rect.height;
                    continue;
                }
                element3.rect.y += this.rect.y + this.rect.height * element3.alignment.horizontal;
                if (element3.pivot.horizontal == 0.0f || element3.pivot.horizontal == 0.5f) {
                    element3.rect.y += element3.padding.top;
                }
                if (element3.pivot.horizontal != 1.0f && element3.pivot.horizontal != 0.5f) continue;
                element3.rect.y -= element3.padding.bottom;
            }
        }
        for (Element element4 : this.elements) {
            element4.rect.x += element4.rect.width * element4.pivot.vertical;
            if (element4.alignment == Alignment.NULL) {
                element4.rect.y += element4.rect.height * element4.pivot.horizontal;
            }
            element4.calcRenderPos(this.rect);
        }
    }

    @Override
    public void calcWidthHeight() {
        super.calcWidthHeight();
        for (Element element : this.elements) {
            this.rect.width += element.rect.width + element.padding.left + element.padding.right;
            this.rect.height = Math.max(this.rect.height, element.rect.height);
        }
    }
}

