/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.animation.text.CharInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpableProperty;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;

public class AnimTextOp
implements IRenderOp {
    public String text;
    public float x;
    public float y;
    public int color;
    public LerpableProperty<CharInfo[]> charInfos;
    public boolean overrideColor;

    public AnimTextOp(String text, float x, float y, int color, LerpableProperty<CharInfo[]> charInfos) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.color = color;
        this.charInfos = charInfos;
    }

    @Override
    public void readTheme(ThemeConfig theme) {
        if (this.color == 0) {
            this.color = theme.animText.parsedColor;
            this.overrideColor = true;
        }
    }

    @Override
    public void execute(RenderContext context) {
        CharInfo[] charInfos1 = this.charInfos.lerp(context.lerpAlpha);
        for (int i = 0; i < Math.min(charInfos1.length, this.text.length()); ++i) {
            String c = String.valueOf(this.text.charAt(i));
            CharInfo info = charInfos1[i];
            RenderUtils.renderText(c, this.x + info.x, this.y + info.y, info.scale, this.overrideColor ? this.color : info.color, info.shadow);
        }
    }
}

