/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.deprecated.mesh2d;

import com.tttsaurus.ingameinfo.deprecated.mesh2d.LineMesh;

public class RoundedRectOutlineMesh
extends LineMesh {
    private final int maxCornerSegment;
    private int cornerSegment;
    private float cornerRadius;
    private float x;
    private float y;
    private float width;
    private float height;
    private int vertexIndex = 0;

    public RoundedRectOutlineMesh(int maxCornerSegment, float lineWidth) {
        super(maxCornerSegment * 4 + 3, lineWidth);
        this.maxCornerSegment = maxCornerSegment;
        this.cornerSegment = maxCornerSegment;
        this.setFormLoop(true);
    }

    public RoundedRectOutlineMesh setCornerRadius(float radius) {
        this.cornerRadius = radius;
        this.cornerSegment = Math.min(this.maxCornerSegment, Math.max(3, (int)(this.cornerRadius / 2.0f)));
        this.setLineNum(this.cornerSegment * 4 + 3);
        return this;
    }

    public RoundedRectOutlineMesh setRect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    private void addArcVertices(float cx, float cy, float startAngle, float endAngle, int segments) {
        startAngle -= 90.0f;
        endAngle -= 90.0f;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)Math.toRadians(startAngle + (endAngle - startAngle) * (float)i / (float)segments);
            float x = (float)((double)cx + Math.cos(angle) * (double)this.cornerRadius);
            float y = (float)((double)cy + Math.sin(angle) * (double)this.cornerRadius);
            this.setVertex(this.vertexIndex++, x, y);
        }
    }

    @Override
    public void update() {
        this.vertexIndex = 0;
        this.addArcVertices(this.x + this.width - this.cornerRadius, this.y + this.cornerRadius, 0.0f, 90.0f, this.cornerSegment);
        this.addArcVertices(this.x + this.width - this.cornerRadius, this.y + this.height - this.cornerRadius, 90.0f, 180.0f, this.cornerSegment);
        this.addArcVertices(this.x + this.cornerRadius, this.y + this.height - this.cornerRadius, 180.0f, 270.0f, this.cornerSegment);
        this.addArcVertices(this.x + this.cornerRadius, this.y + this.cornerRadius, 270.0f, 360.0f, this.cornerSegment);
        super.update();
    }
}

