/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core;

import com.tttsaurus.ingameinfo.common.core.forgeevent.IgiGuiLifecycleInitEvent;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLifecycleHolder;
import com.tttsaurus.ingameinfo.common.core.mvvm.registry.MvvmRegistry;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.impl.gui.DefaultLifecycleHolder;
import com.tttsaurus.ingameinfo.config.IgiCommonConfig;
import crafttweaker.annotations.ZenRegister;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public final class IgiRuntime {
    private static IgiRuntime instance;
    private final MvvmRegistry mvvmRegistry = new MvvmRegistry();
    private final DefaultLifecycleHolder lifecycleHolder = new DefaultLifecycleHolder();
    private final List<GuiLifecycleHolder> externaLifecycleHolders;
    public final InitPhaseEntry initPhase;
    public final LivePhaseEntry livePhase;
    public final GlobalEntry global;

    private static void init() {
        instance = new IgiRuntime();
    }

    private IgiRuntime() {
        this.lifecycleHolder.setLifecycleProvider(IgiCommonConfig.GUI_LIFECYCLE_PROVIDER);
        this.externaLifecycleHolders = new ArrayList<GuiLifecycleHolder>();
        this.initPhase = new InitPhaseEntry(this.mvvmRegistry);
        this.livePhase = new LivePhaseEntry(this.mvvmRegistry, this.lifecycleHolder);
        this.global = new GlobalEntry(this.mvvmRegistry, this.lifecycleHolder, this.externaLifecycleHolders);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.lifecycleHolder.update();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onIgiGuiLifecycleInit(IgiGuiLifecycleInitEvent event) {
        if (event.lifecycleOwner.equals("official_igi_lifecycle_holder")) {
            for (String string : this.initPhase.guisToOpenWhenLifecycleInit) {
                this.lifecycleHolder.openGui(string, this.mvvmRegistry);
            }
            this.initPhase.guisToOpenWhenLifecycleInit.clear();
        }
        for (Map.Entry entry : new ArrayList(this.global.guisToOpenWhenLifecycleInit.entrySet())) {
            if (!event.lifecycleOwner.equals(((GuiLifecycleHolder)entry.getKey()).getHolderName())) continue;
            for (String mvvmRegistryName : (List)entry.getValue()) {
                ((GuiLifecycleHolder)entry.getKey()).openGui(mvvmRegistryName, this.mvvmRegistry);
            }
            this.global.guisToOpenWhenLifecycleInit.remove(entry.getKey());
        }
    }

    @ZenRegister
    @ZenClass(value="mods.ingameinfo.runtime.InitPhaseEntry")
    public static class InitPhaseEntry {
        private final MvvmRegistry mvvmRegistry;
        private final List<String> guisToOpenWhenLifecycleInit = new ArrayList<String>();

        private InitPhaseEntry(MvvmRegistry mvvmRegistry) {
            this.mvvmRegistry = mvvmRegistry;
        }

        public InitPhaseEntry registerMvvm(String mvvmRegistryName, Class<? extends ViewModel<?>> viewModelClass) {
            this.mvvmRegistry.autoRegister(mvvmRegistryName, viewModelClass);
            return this;
        }

        @ZenMethod
        public InitPhaseEntry openGuiOnStartup(String mvvmRegistryName) {
            if (!this.guisToOpenWhenLifecycleInit.contains(mvvmRegistryName)) {
                this.guisToOpenWhenLifecycleInit.add(mvvmRegistryName);
            }
            return this;
        }
    }

    @ZenRegister
    @ZenClass(value="mods.ingameinfo.runtime.LivePhaseEntry")
    public static class LivePhaseEntry {
        private final MvvmRegistry mvvmRegistry;
        private final DefaultLifecycleHolder lifecycleHolder;

        private LivePhaseEntry(MvvmRegistry mvvmRegistry, DefaultLifecycleHolder lifecycleHolder) {
            this.mvvmRegistry = mvvmRegistry;
            this.lifecycleHolder = lifecycleHolder;
        }

        @ZenMethod
        public LivePhaseEntry openGui(String mvvmRegistryName) {
            this.lifecycleHolder.openGui(mvvmRegistryName, this.mvvmRegistry);
            return this;
        }

        @ZenMethod
        public LivePhaseEntry closeGui(String mvvmRegistryName) {
            this.lifecycleHolder.closeGui(mvvmRegistryName);
            return this;
        }
    }

    public static class GlobalEntry {
        public final MvvmRegistry mvvmRegistry;
        public final DefaultLifecycleHolder lifecycleHolder;
        private final List<GuiLifecycleHolder> externaLifecycleHolders;
        private final Map<GuiLifecycleHolder, List<String>> guisToOpenWhenLifecycleInit = new HashMap<GuiLifecycleHolder, List<String>>();

        private GlobalEntry(MvvmRegistry mvvmRegistry, DefaultLifecycleHolder lifecycleHolder, List<GuiLifecycleHolder> externaLifecycleHolders) {
            this.mvvmRegistry = mvvmRegistry;
            this.lifecycleHolder = lifecycleHolder;
            this.externaLifecycleHolders = externaLifecycleHolders;
        }

        public GuiLifecycleHolder registerLifecycleHolder(Class<? extends GuiLifecycleHolder> holderClass) {
            if (holderClass.equals(DefaultLifecycleHolder.class)) {
                return null;
            }
            for (GuiLifecycleHolder otherHolder : this.externaLifecycleHolders) {
                if (!otherHolder.getClass().getName().equals(holderClass.getName())) continue;
                return null;
            }
            try {
                Constructor<? extends GuiLifecycleHolder> constructor = holderClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                GuiLifecycleHolder holder = constructor.newInstance(new Object[0]);
                if ("official_igi_lifecycle_holder".equals(holder.getHolderName())) {
                    return null;
                }
                for (GuiLifecycleHolder otherHolder : this.externaLifecycleHolders) {
                    if (!otherHolder.getHolderName().equals(holder.getHolderName())) continue;
                    return null;
                }
                this.externaLifecycleHolders.add(holder);
                return holder;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public GlobalEntry openGuiOnStartup(String holderName, String mvvmRegistryName) {
            GuiLifecycleHolder holder = null;
            if (holderName.equals("official_igi_lifecycle_holder")) {
                holder = this.lifecycleHolder;
            } else {
                for (GuiLifecycleHolder otherHolder : this.externaLifecycleHolders) {
                    if (!holderName.equals(otherHolder.getHolderName())) continue;
                    holder = otherHolder;
                    break;
                }
            }
            if (holder == null) {
                return this;
            }
            List list = this.guisToOpenWhenLifecycleInit.computeIfAbsent(holder, k -> new ArrayList());
            if (!list.contains(mvvmRegistryName)) {
                list.add(mvvmRegistryName);
            }
            return this;
        }
    }
}

