/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.function.IAction_1Param;
import com.tttsaurus.ingameinfo.common.core.gui.event.IUIEventListener;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEventListenerType;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Alignment;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Padding;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Pivot;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.ICopyableLerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.ILerpablePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.ITargetingLerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTargetCopyUtils;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpableProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySyncTo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.BackgroundOp;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.DebugRectOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.input.InputState;
import com.tttsaurus.ingameinfo.common.core.reflection.FieldUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RegisterElement(constructable=false)
public abstract class Element {
    public float cachedWidth = 0.0f;
    public float cachedHeight = 0.0f;
    public Padding cachedPadding = new Padding(0.0f, 0.0f, 0.0f, 0.0f);
    public Rect rect = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    public float pivotPosX = 0.0f;
    public float pivotPosY = 0.0f;
    public Rect contextRect = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean needReCalc = false;
    private final Map<String, IStylePropertySyncTo> syncToMap = new HashMap<String, IStylePropertySyncTo>();
    private Map<LerpableProperty<?>, ITargetingLerpTarget> lerpTargetGetters = null;
    private final Map<Class<? extends UIEvent>, List<IUIEventListener<?>>> uiEventListeners = new HashMap();
    private ElementGroup parent = null;
    @StyleProperty(setterCallbackPre="setEnabledCallbackPre")
    public boolean enabled = true;
    @StyleProperty(setterCallbackPre="uidValidation")
    public String uid = "";
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="alignmentValidation")
    public Alignment alignment = Alignment.NULL;
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="pivotValidation")
    public Pivot pivot = Pivot.TOP_LEFT;
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="setPaddingCallbackPre")
    public Padding padding = new Padding(0.0f, 0.0f, 0.0f, 0.0f);
    @StyleProperty(setterCallbackPre="backgroundStyleValidation")
    public String backgroundStyle = "";
    @StyleProperty
    public boolean drawBackground = false;

    @StylePropertyCallback
    public void requestReCalc() {
        this.needReCalc = true;
    }

    @StylePropertyCallback
    public void setEnabledCallbackPre(boolean value, CallbackInfo callbackInfo) {
        if (!this.enabled && value) {
            this.rect.width = this.cachedWidth;
            this.rect.height = this.cachedHeight;
            this.padding.set(this.cachedPadding.top, this.cachedPadding.bottom, this.cachedPadding.left, this.cachedPadding.right);
            this.requestReCalc();
        }
        if (this.enabled && !value) {
            this.cachedWidth = this.rect.width;
            this.cachedHeight = this.rect.height;
            this.rect.width = 0.0f;
            this.rect.height = 0.0f;
            this.cachedPadding.set(this.padding.top, this.padding.bottom, this.padding.left, this.padding.right);
            this.padding.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.requestReCalc();
        }
    }

    @StylePropertyCallback
    public void uidValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
            return;
        }
        if (value.isEmpty()) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void alignmentValidation(Alignment value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void pivotValidation(Pivot value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setPaddingCallbackPre(Padding value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
            return;
        }
        if (!this.enabled) {
            this.cachedPadding.set(value.top, value.bottom, value.left, value.right);
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void backgroundStyleValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    protected final <T extends UIEvent> void fireEvent(T event) {
        List<IUIEventListener<?>> list = this.uiEventListeners.get(event.getClass());
        if (list != null) {
            for (IUIEventListener<?> listener : list) {
                if (listener.type() != UIEventListenerType.LOCAL) continue;
                listener.handle(event);
            }
        }
        if (event.isConsumed()) {
            return;
        }
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        Element parent = this;
        stack.push(parent);
        while (parent.parent != null) {
            parent = parent.parent;
            stack.push(parent);
        }
        while (!stack.isEmpty()) {
            Element element = (Element)stack.pop();
            List<IUIEventListener<?>> list2 = element.uiEventListeners.get(event.getClass());
            if (list2 == null) continue;
            for (IUIEventListener<?> listener : list2) {
                if (listener.type() != UIEventListenerType.CAPTURE) continue;
                listener.handle(event);
            }
        }
        if (event.isConsumed()) {
            return;
        }
        if (list != null) {
            for (IUIEventListener iUIEventListener : list) {
                if (iUIEventListener.type() != UIEventListenerType.TARGET) continue;
                iUIEventListener.handle(event);
            }
        }
        if (event.isConsumed()) {
            return;
        }
        parent = this;
        while (parent.parent != null) {
            List<IUIEventListener<?>> list2 = parent.uiEventListeners.get(event.getClass());
            if (list2 != null) {
                for (IUIEventListener<?> listener : list2) {
                    if (listener.type() != UIEventListenerType.BUBBLE) continue;
                    listener.handle(event);
                }
            }
            parent = parent.parent;
        }
    }

    public final <T extends UIEvent> void addEventListener(Class<T> type, IUIEventListener<T> listener) {
        this.uiEventListeners.computeIfAbsent(type, k -> new ArrayList()).add(listener);
    }

    public final void setStyleProperty(String propertyName, Object value) {
        IAction_1Param<Object> action = ElementRegistry.getStylePropertySetterFullCallback(this, propertyName);
        if (action != null) {
            action.invoke(value);
            IStylePropertySyncTo sync = this.syncToMap.get(propertyName);
            if (sync != null) {
                sync.sync();
            }
        }
    }

    public void onCollectLerpInfo() {
        if (this.lerpTargetGetters == null) {
            this.lerpTargetGetters = new HashMap();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            List<ILerpablePropertyGetter> getters = ElementRegistry.getLerpablePropertyGetters(this.getClass());
            for (ILerpablePropertyGetter iLerpablePropertyGetter : getters) {
                LerpTarget lerpTarget = ElementRegistry.getLerpTarget(this.getClass(), iLerpablePropertyGetter);
                if (lerpTarget == null) continue;
                LerpableProperty<?> property = iLerpablePropertyGetter.get(this);
                ITargetingLerpTarget targetGetter = null;
                try {
                    boolean copyArray;
                    Field field = FieldUtils.getFieldByNameIncludingSuperclasses(this.getClass(), lerpTarget.value());
                    MethodHandle handle = lookup.unreflectGetter(field);
                    boolean copy = lerpTarget.copyIfPossible() && ICopyableLerpTarget.class.isAssignableFrom(field.getType());
                    boolean bl = copyArray = lerpTarget.copyIfPossible() && field.getType().getComponentType() != null && ICopyableLerpTarget.class.isAssignableFrom(field.getType().getComponentType());
                    if (lerpTarget.inner0().isEmpty()) {
                        targetGetter = () -> {
                            try {
                                Object res = handle.invoke(this);
                                if (copy || copyArray) {
                                    return LerpTargetCopyUtils.copy(res);
                                }
                                return res;
                            }
                            catch (Throwable ignored) {
                                return null;
                            }
                        };
                    } else {
                        boolean copyArrayInner0;
                        Field fieldInner0 = FieldUtils.getFieldByNameIncludingSuperclasses(field.getType(), lerpTarget.inner0());
                        MethodHandle handleInner0 = lookup.unreflectGetter(fieldInner0);
                        boolean copyInner0 = lerpTarget.copyIfPossible() && ICopyableLerpTarget.class.isAssignableFrom(fieldInner0.getType());
                        boolean bl2 = copyArrayInner0 = lerpTarget.copyIfPossible() && fieldInner0.getType().getComponentType() != null && ICopyableLerpTarget.class.isAssignableFrom(fieldInner0.getType().getComponentType());
                        if (lerpTarget.inner1().isEmpty()) {
                            targetGetter = () -> {
                                try {
                                    Object res = handleInner0.invoke(handle.invoke(this));
                                    if (copyInner0 || copyArrayInner0) {
                                        return LerpTargetCopyUtils.copy(res);
                                    }
                                    return res;
                                }
                                catch (Throwable ignored) {
                                    return null;
                                }
                            };
                        } else {
                            Field fieldInner1 = FieldUtils.getFieldByNameIncludingSuperclasses(fieldInner0.getType(), lerpTarget.inner1());
                            MethodHandle handleInner1 = lookup.unreflectGetter(fieldInner1);
                            boolean copyInner1 = lerpTarget.copyIfPossible() && ICopyableLerpTarget.class.isAssignableFrom(fieldInner1.getType());
                            boolean copyArrayInner1 = lerpTarget.copyIfPossible() && fieldInner1.getType().getComponentType() != null && ICopyableLerpTarget.class.isAssignableFrom(fieldInner1.getType().getComponentType());
                            targetGetter = () -> {
                                try {
                                    Object res = handleInner1.invoke(handleInner0.invoke(handle.invoke(this)));
                                    if (copyInner1 || copyArrayInner1) {
                                        return LerpTargetCopyUtils.copy(res);
                                    }
                                    return res;
                                }
                                catch (Throwable ignored) {
                                    return null;
                                }
                            };
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (targetGetter == null) continue;
                targetGetter.getTarget();
                this.lerpTargetGetters.put(property, targetGetter);
            }
        }
        for (Map.Entry<LerpableProperty<?>, ITargetingLerpTarget> entry : this.lerpTargetGetters.entrySet()) {
            LerpableProperty<?> property = entry.getKey();
            ITargetingLerpTarget iTargetingLerpTarget = entry.getValue();
            Object target = iTargetingLerpTarget.getTarget();
            if (property.getCurrValue() == null) {
                property.setPrevValue(target);
            } else {
                property.setPrevValue(property.getCurrValue());
            }
            property.setCurrValue(target);
        }
    }

    public void resetRenderInfo() {
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.contextRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.pivotPosX = 0.0f;
        this.pivotPosY = 0.0f;
    }

    public void calcRenderPos(Rect contextRect) {
        this.contextRect.set(contextRect.x, contextRect.y, contextRect.width, contextRect.height);
        this.pivotPosX = this.rect.x;
        this.rect.x -= this.rect.width * this.pivot.vertical;
        this.pivotPosY = this.rect.y;
        this.rect.y -= this.rect.height * this.pivot.horizontal;
    }

    public abstract void calcWidthHeight();

    public void onFixedUpdate(double deltaTime) {
    }

    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        if (this.drawBackground) {
            queue.enqueue(new BackgroundOp(this.backgroundStyle, this.rect));
        }
    }

    public void onPropagateInput(InputState inputState) {
    }

    public boolean getNeedReCalc() {
        return this.needReCalc;
    }

    public void finishReCalc() {
        this.needReCalc = false;
    }

    public void applyLogicTheme(ThemeConfig themeConfig) {
        if (this.backgroundStyle.isEmpty()) {
            this.setStyleProperty("backgroundStyle", themeConfig.element.backgroundStyle);
        }
    }

    public void renderDebugRect(RenderOpQueue queue) {
        queue.enqueue(new DebugRectOp(false, this.rect, this.pivotPosX, this.pivotPosY));
    }

    public ElementGroup getParent() {
        return this.parent;
    }
}

