/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySetter;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ElementAccessor {
    private final Element element;

    public ElementAccessor(Element element) {
        this.element = element;
    }

    private List<Element> getElements(String uid) {
        if (ElementGroup.class.isAssignableFrom(this.element.getClass())) {
            return this.getElements((ElementGroup)this.element, uid);
        }
        if (this.element.uid.equals(uid)) {
            return new ArrayList<Element>(Arrays.asList(this.element));
        }
        return new ArrayList<Element>();
    }

    private List<Element> getElements(ElementGroup group, String uid) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (group.uid.equals(uid)) {
            list.add(group);
        }
        for (Element element : group.elements) {
            if (ElementGroup.class.isAssignableFrom(element.getClass())) {
                ElementGroup nextGroup = (ElementGroup)element;
                list.addAll(this.getElements(nextGroup, uid));
                continue;
            }
            if (!element.uid.equals(uid)) continue;
            list.add(element);
        }
        return list;
    }

    public void set(String propertyName, Object value) {
        this.element.setStyleProperty(propertyName, value);
    }

    public void set(String uid, String propertyName, Object value) {
        this.set(uid, propertyName, value, -1);
    }

    public void set(String uid, String propertyName, Object value, int ordinal) {
        List<Element> list = this.getElements(uid);
        int index = 0;
        for (Element item : list) {
            if (ordinal != -1 && ordinal != index++) continue;
            item.setStyleProperty(propertyName, value);
        }
    }

    public Object get(String propertyName) {
        IStylePropertySetter setter = ElementRegistry.getStylePropertySetter(this.element.getClass(), propertyName);
        if (setter == null) {
            return null;
        }
        IStylePropertyGetter getter = ElementRegistry.getStylePropertyGetter(setter);
        if (getter == null) {
            return null;
        }
        return getter.get(this.element);
    }

    public Object get(String uid, String propertyName) {
        return this.get(uid, propertyName, -1);
    }

    public Object get(String uid, String propertyName, int ordinal) {
        List<Element> list = this.getElements(uid);
        Object res = null;
        int index = 0;
        for (Element item : list) {
            IStylePropertyGetter getter;
            IStylePropertySetter setter;
            if (ordinal != -1 && ordinal != index++ || (setter = ElementRegistry.getStylePropertySetter(item.getClass(), propertyName)) == null || (getter = ElementRegistry.getStylePropertyGetter(setter)) == null) continue;
            res = getter.get(item);
        }
        return res;
    }
}

