/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.ElementProperty;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.MainGroup;
import com.tttsaurus.ingameinfo.common.core.item.GhostableItem;
import java.util.ArrayList;
import java.util.List;

public final class GuiLayout {
    private IgiGuiContainer igiGuiContainer;
    private MainGroup mainGroup;
    private int groupLayer = 0;
    private final List<ElementGroup> groupBuffer = new ArrayList<ElementGroup>();

    protected GuiLayout() {
        this.igiGuiContainer = new IgiGuiContainer();
        this.mainGroup = this.igiGuiContainer.mainGroup;
    }

    public GuiLayout setDebug(boolean debug) {
        this.igiGuiContainer.debug = debug;
        return this;
    }

    public GuiLayout setExitKeyForFocusedGui(int keycode) {
        this.igiGuiContainer.exitKeyForFocusedGui = keycode;
        return this;
    }

    public GuiLayout setFocused(boolean focused) {
        this.igiGuiContainer.isFocused = focused;
        return this;
    }

    public GuiLayout setHasFocusBackground(boolean hasFocusBackground) {
        this.igiGuiContainer.hasFocusBackground = hasFocusBackground;
        return this;
    }

    public GuiLayout setBackgroundColor(int color) {
        this.igiGuiContainer.backgroundColor = color;
        return this;
    }

    public GuiLayout setHeldItemWhitelist(boolean flag) {
        this.igiGuiContainer.useHeldItemWhitelist = flag;
        return this;
    }

    public GuiLayout setHeldItemBlacklist(boolean flag) {
        this.igiGuiContainer.useHeldItemBlacklist = flag;
        return this;
    }

    public GuiLayout addHeldItemWhitelist(GhostableItem item) {
        this.igiGuiContainer.heldItemWhitelist.add(item);
        return this;
    }

    public GuiLayout addHeldItemBlacklist(GhostableItem item) {
        this.igiGuiContainer.heldItemBlacklist.add(item);
        return this;
    }

    public GuiLayout setThemeName(String themeName) {
        this.igiGuiContainer.themeName = themeName;
        return this;
    }

    private void startGroupInternal(ElementGroup group) {
        this.groupBuffer.add(group);
        ++this.groupLayer;
    }

    public GuiLayout endGroup() {
        --this.groupLayer;
        if (this.groupLayer - 1 < 0) {
            this.mainGroup.add(this.groupBuffer.get(this.groupLayer));
            this.groupBuffer.remove(this.groupBuffer.size() - 1);
        } else {
            this.groupBuffer.get(this.groupLayer - 1).add(this.groupBuffer.get(this.groupLayer));
            this.groupBuffer.remove(this.groupBuffer.size() - 1);
        }
        return this;
    }

    public GuiLayout startGroup(ElementGroup group) {
        this.startGroupInternal(group);
        return this;
    }

    public GuiLayout startGroup(ElementGroup group, List<ElementProperty> properties) {
        this.injectStyleProperties(group, properties);
        this.startGroupInternal(group);
        return this;
    }

    private void addElementInternal(Element element) {
        if (this.groupLayer - 1 < 0) {
            this.mainGroup.add(element);
        } else {
            this.groupBuffer.get(this.groupLayer - 1).add(element);
        }
    }

    public GuiLayout addElement(Element element) {
        this.addElementInternal(element);
        return this;
    }

    public GuiLayout addElement(Element element, List<ElementProperty> properties) {
        this.injectStyleProperties(element, properties);
        this.addElementInternal(element);
        return this;
    }

    private void injectStyleProperties(Element element, List<ElementProperty> properties) {
        for (ElementProperty style : properties) {
            element.setStyleProperty(style.name, style.value);
        }
    }
}

