/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Sized;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.input.InputState;

@RegisterElement(constructable=false)
public abstract class Interactable
extends Sized {
    protected boolean hover = false;
    protected boolean hold = false;

    @Override
    public void onPropagateInput(InputState inputState) {
        super.onPropagateInput(inputState);
        if (this.rect.contains(inputState.posX, inputState.posY)) {
            inputState.consume();
            if (!this.hover) {
                this.hover = true;
                this.fireEvent(new UIEvent.MouseEnter(inputState, this));
            }
            if (inputState.leftDown) {
                if (!this.hold) {
                    this.hold = true;
                    this.fireEvent(new UIEvent.MousePress(inputState, this));
                }
            } else if (this.hold) {
                this.hover = false;
                this.hold = false;
                this.fireEvent(new UIEvent.MouseRelease(inputState, this));
            }
        } else if (this.hover) {
            this.hover = false;
            this.hold = false;
            this.fireEvent(new UIEvent.MouseLeave(inputState, this));
        }
    }
}

