/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.layout;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public final class MainGroup
extends ElementGroup {
    public MainGroup() {
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        this.rect.width = (float)resolution.func_78327_c();
        this.rect.height = (float)resolution.func_78324_d();
    }

    @Override
    public void calcRenderPos(Rect contextRect) {
        super.calcRenderPos(contextRect);
        if (this.elements.isEmpty()) {
            return;
        }
        for (Element element : this.elements) {
            element.rect.x = this.rect.x + this.rect.width * element.alignment.vertical;
            element.rect.y = this.rect.y + this.rect.height * element.alignment.horizontal;
            if (element.pivot.vertical == 0.0f || element.pivot.vertical == 0.5f) {
                element.rect.x += element.padding.left;
            }
            if (element.pivot.vertical == 1.0f || element.pivot.vertical == 0.5f) {
                element.rect.x -= element.padding.right;
            }
            if (element.pivot.horizontal == 0.0f || element.pivot.horizontal == 0.5f) {
                element.rect.y += element.padding.top;
            }
            if (element.pivot.horizontal == 1.0f || element.pivot.horizontal == 0.5f) {
                element.rect.y -= element.padding.bottom;
            }
            element.calcRenderPos(this.rect);
        }
    }

    @Override
    public void calcWidthHeight() {
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        this.rect.width = (float)resolution.func_78327_c();
        this.rect.height = (float)resolution.func_78324_d();
        super.calcWidthHeight();
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        for (Element element : this.elements) {
            if (!element.enabled) continue;
            element.onRenderUpdate(queue, focused);
        }
    }

    @Override
    public void renderDebugRect(RenderOpQueue queue) {
        for (Element element : this.elements) {
            element.renderDebugRect(queue);
        }
    }
}

