/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.tttsaurus.ingameinfo.common.core.function.IAction_1Param;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.ILerpablePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyCallbackPost;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyCallbackPre;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySetter;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegistryUtils;
import com.tttsaurus.ingameinfo.common.core.serialization.IDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ElementRegistry {
    private static final Map<String, Map<String, IStylePropertySetter>> stylePropertySetters = new HashMap<String, Map<String, IStylePropertySetter>>();
    private static final Map<IStylePropertySetter, IDeserializer<?>> stylePropertyDeserializers = new HashMap();
    private static final Map<IStylePropertySetter, IStylePropertyCallbackPre> stylePropertySetterCallbacksPre = new HashMap<IStylePropertySetter, IStylePropertyCallbackPre>();
    private static final Map<IStylePropertySetter, IStylePropertyCallbackPost> stylePropertySetterCallbacksPost = new HashMap<IStylePropertySetter, IStylePropertyCallbackPost>();
    private static final Map<IStylePropertySetter, Class<?>> stylePropertyClasses = new HashMap();
    private static final Map<IStylePropertySetter, IStylePropertyGetter> stylePropertyGetters = new HashMap<IStylePropertySetter, IStylePropertyGetter>();
    private static final Map<String, Class<? extends Element>> registeredElements = new HashMap<String, Class<? extends Element>>();
    private static final Map<Class<? extends Element>, RegisterElement> elementAnnotations = new HashMap<Class<? extends Element>, RegisterElement>();
    private static final Map<String, Map<ILerpablePropertyGetter, LerpTarget>> lerpablePropertyGetters = new HashMap<String, Map<ILerpablePropertyGetter, LerpTarget>>();

    @Nullable
    public static IStylePropertySetter getStylePropertySetter(Class<? extends Element> clazz, String name) {
        Map<String, IStylePropertySetter> map;
        if (stylePropertySetters.containsKey(clazz.getName()) && (map = stylePropertySetters.get(clazz.getName())).containsKey(name)) {
            return map.get(name);
        }
        if (Element.class.isAssignableFrom(clazz.getSuperclass())) {
            return ElementRegistry.getStylePropertySetter(clazz.getSuperclass(), name);
        }
        return null;
    }

    @Nullable
    public static IDeserializer<?> getStylePropertyDeserializer(IStylePropertySetter setter) {
        return stylePropertyDeserializers.get(setter);
    }

    @Nullable
    public static IStylePropertyCallbackPre getStylePropertySetterCallbackPre(IStylePropertySetter setter) {
        return stylePropertySetterCallbacksPre.get(setter);
    }

    @Nullable
    public static IStylePropertyCallbackPost getStylePropertySetterCallbackPost(IStylePropertySetter setter) {
        return stylePropertySetterCallbacksPost.get(setter);
    }

    @Nullable
    public static Class<?> getStylePropertyClass(IStylePropertySetter setter) {
        return stylePropertyClasses.get(setter);
    }

    @Nullable
    public static IStylePropertyGetter getStylePropertyGetter(IStylePropertySetter setter) {
        return stylePropertyGetters.get(setter);
    }

    @Nullable
    public static Element newElement(String name) {
        Class<? extends Element> clazz = registeredElements.get(name);
        if (clazz == null) {
            return null;
        }
        RegisterElement annotation = elementAnnotations.get(clazz);
        if (annotation == null) {
            return null;
        }
        if (!annotation.constructable()) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static IAction_1Param<Object> getStylePropertySetterFullCallback(@Nonnull Element element, String propertyName) {
        IStylePropertySetter setter = ElementRegistry.getStylePropertySetter(element.getClass(), propertyName);
        if (setter == null) {
            return null;
        }
        return ElementRegistry.getStylePropertySetterWithCallbacksHandled(setter, element, ElementRegistry.getStylePropertySetterCallbackPre(setter), ElementRegistry.getStylePropertySetterCallbackPost(setter));
    }

    private static IAction_1Param<Object> getStylePropertySetterWithCallbacksHandled(@Nonnull IStylePropertySetter setter, @Nonnull Element element, IStylePropertyCallbackPre setterCallbackPre, IStylePropertyCallbackPost setterCallbackPost) {
        return value -> {
            CallbackInfo callbackInfo = new CallbackInfo();
            if (setterCallbackPre != null) {
                setterCallbackPre.invoke(element, value, callbackInfo);
            }
            if (!callbackInfo.cancel) {
                setter.set(element, value);
                if (setterCallbackPost != null) {
                    setterCallbackPost.invoke(element, value);
                }
            }
        };
    }

    public static ImmutableMap<String, Map<String, IStylePropertySetter>> getStylePropertySetters() {
        return ImmutableMap.copyOf(stylePropertySetters);
    }

    public static ImmutableMap<IStylePropertySetter, IDeserializer<?>> getStylePropertyDeserializers() {
        return ImmutableMap.copyOf(stylePropertyDeserializers);
    }

    public static ImmutableMap<IStylePropertySetter, IStylePropertyCallbackPre> getStylePropertySetterCallbacksPre() {
        return ImmutableMap.copyOf(stylePropertySetterCallbacksPre);
    }

    public static ImmutableMap<IStylePropertySetter, IStylePropertyCallbackPost> getStylePropertySetterCallbacksPost() {
        return ImmutableMap.copyOf(stylePropertySetterCallbacksPost);
    }

    public static ImmutableMap<IStylePropertySetter, Class<?>> getStylePropertyClasses() {
        return ImmutableMap.copyOf(stylePropertyClasses);
    }

    public static ImmutableList<Class<? extends Element>> getRegisteredElements() {
        return ImmutableList.copyOf(registeredElements.values());
    }

    public static List<Class<? extends Element>> getConstructableElements() {
        ArrayList<Class<? extends Element>> list = new ArrayList<Class<? extends Element>>();
        for (Class<? extends Element> clazz : registeredElements.values()) {
            RegisterElement annotation = elementAnnotations.get(clazz);
            if (annotation == null || !annotation.constructable()) continue;
            list.add(clazz);
        }
        return list;
    }

    public static ImmutableMap<String, Map<ILerpablePropertyGetter, LerpTarget>> getLerpablePropertyGetters() {
        return ImmutableMap.copyOf(lerpablePropertyGetters);
    }

    public static List<ILerpablePropertyGetter> getLerpablePropertyGetters(Class<? extends Element> clazz) {
        Map<ILerpablePropertyGetter, LerpTarget> map = lerpablePropertyGetters.get(clazz.getName());
        if (map == null) {
            return new ArrayList<ILerpablePropertyGetter>();
        }
        if (Element.class.isAssignableFrom(clazz.getSuperclass())) {
            List<ILerpablePropertyGetter> list = ElementRegistry.getLerpablePropertyGetters(clazz.getSuperclass());
            list.addAll(new ArrayList<ILerpablePropertyGetter>(map.keySet()));
            return list;
        }
        return new ArrayList<ILerpablePropertyGetter>(map.keySet());
    }

    @Nullable
    public static LerpTarget getLerpTarget(Class<? extends Element> clazz, ILerpablePropertyGetter getter) {
        Map<ILerpablePropertyGetter, LerpTarget> map;
        if (lerpablePropertyGetters.containsKey(clazz.getName()) && (map = lerpablePropertyGetters.get(clazz.getName())).containsKey(getter)) {
            return map.get(getter);
        }
        if (Element.class.isAssignableFrom(clazz.getSuperclass())) {
            return ElementRegistry.getLerpTarget(clazz.getSuperclass(), getter);
        }
        return null;
    }

    public static void register() {
        registeredElements.clear();
        elementAnnotations.clear();
        registeredElements.putAll(RegistryUtils.handleRegisteredElements(elementAnnotations));
        stylePropertySetters.clear();
        stylePropertyDeserializers.clear();
        stylePropertySetterCallbacksPre.clear();
        stylePropertySetterCallbacksPost.clear();
        stylePropertyClasses.clear();
        stylePropertyGetters.clear();
        for (Class<? extends Element> clazz : registeredElements.values()) {
            stylePropertySetters.put(clazz.getName(), RegistryUtils.handleStyleProperties(clazz, stylePropertyDeserializers, stylePropertySetterCallbacksPre, stylePropertySetterCallbacksPost, stylePropertyClasses, stylePropertyGetters));
        }
        lerpablePropertyGetters.clear();
        for (Class<? extends Element> clazz : registeredElements.values()) {
            lerpablePropertyGetters.put(clazz.getName(), RegistryUtils.handleLerpableProperties(clazz));
        }
    }
}

