/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.GuiResources;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;

public class BackgroundOp
implements IRenderOp {
    public String backgroundStyle;
    public Rect rect;

    public BackgroundOp(String backgroundStyle, Rect rect) {
        this.backgroundStyle = backgroundStyle;
        this.rect = rect;
    }

    @Override
    public void execute(RenderContext context) {
        if (this.backgroundStyle.isEmpty()) {
            return;
        }
        switch (this.backgroundStyle) {
            case "box": {
                RenderUtils.renderRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.backgroundStyles.box.parsedColor);
                break;
            }
            case "box-with-outline": {
                RenderUtils.renderRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.backgroundStyles.boxWithOutline.parsedColor);
                RenderUtils.renderRectOutline(this.rect.x, this.rect.y, this.rect.width, this.rect.height, 1.0f, context.theme.backgroundStyles.boxWithOutline.parsedOutlineColor);
                break;
            }
            case "rounded-box": {
                RenderUtils.renderRoundedRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.backgroundStyles.roundedBox.cornerRadius, context.theme.backgroundStyles.roundedBox.parsedColor, context.polygonSmoothHint);
                break;
            }
            case "rounded-box-with-outline": {
                RenderUtils.renderRoundedRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.backgroundStyles.roundedBoxWithOutline.cornerRadius, context.theme.backgroundStyles.roundedBoxWithOutline.parsedColor, context.polygonSmoothHint);
                RenderUtils.renderRoundedRectOutline(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.backgroundStyles.roundedBoxWithOutline.cornerRadius, 1.0f, context.theme.backgroundStyles.roundedBoxWithOutline.parsedOutlineColor, context.lineSmoothHint);
                break;
            }
            case "mc-vanilla": {
                RenderUtils.renderImagePrefab(this.rect.x, this.rect.y, this.rect.width, this.rect.height, GuiResources.get("vanilla_background"), context.theme.backgroundStyles.mcVanilla.parsedColor);
            }
        }
    }
}

