/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.theme;

import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.ConfigurationNode;

public final class ThemeConfigUpdater {
    private final ConfigurationNode root;
    private final ThemeConfig config;
    private final int version;

    private int parseColor(String hex) {
        if (hex == null) {
            return 0;
        }
        if (hex.isEmpty()) {
            return 0;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() == 6) {
            return 0xFF000000 | Integer.parseInt(hex, 16);
        }
        if (hex.length() == 8) {
            return (int)Long.parseLong(hex, 16);
        }
        return 0;
    }

    private void parse() {
        this.config.backgroundStyles.box.parsedColor = this.parseColor(this.config.backgroundStyles.box.color);
        this.config.backgroundStyles.boxWithOutline.parsedColor = this.parseColor(this.config.backgroundStyles.boxWithOutline.color);
        this.config.backgroundStyles.boxWithOutline.parsedOutlineColor = this.parseColor(this.config.backgroundStyles.boxWithOutline.outlineColor);
        this.config.backgroundStyles.roundedBox.parsedColor = this.parseColor(this.config.backgroundStyles.roundedBox.color);
        this.config.backgroundStyles.roundedBoxWithOutline.parsedColor = this.parseColor(this.config.backgroundStyles.roundedBoxWithOutline.color);
        this.config.backgroundStyles.roundedBoxWithOutline.parsedOutlineColor = this.parseColor(this.config.backgroundStyles.roundedBoxWithOutline.outlineColor);
        this.config.backgroundStyles.mcVanilla.parsedColor = this.parseColor(this.config.backgroundStyles.mcVanilla.color);
        this.config.text.parsedColor = this.parseColor(this.config.text.color);
        this.config.slidingText.parsedColor = this.parseColor(this.config.slidingText.color);
        this.config.animText.parsedColor = this.parseColor(this.config.animText.color);
        this.config.progressBar.parsedFillerColor = this.parseColor(this.config.progressBar.fillerColor);
        this.config.progressBar.parsedBackgroundColor = this.parseColor(this.config.progressBar.backgroundColor);
        this.config.progressBar.parsedOutlineColor = this.parseColor(this.config.progressBar.outlineColor);
        this.config.button.parsedDefaultColor = this.parseColor(this.config.button.defaultColor);
        this.config.button.parsedHoverColor = this.parseColor(this.config.button.hoverColor);
        this.config.button.parsedHoldColor = this.parseColor(this.config.button.holdColor);
        this.config.button.parsedDefaultTextColor = this.parseColor(this.config.button.defaultTextColor);
        this.config.button.parsedHoverTextColor = this.parseColor(this.config.button.hoverTextColor);
        this.config.button.parsedHoldTextColor = this.parseColor(this.config.button.holdTextColor);
    }

    private void validate() {
        this.config.backgroundStyles.roundedBox.cornerRadius = Math.max(0.0f, this.config.backgroundStyles.roundedBox.cornerRadius);
        this.config.backgroundStyles.roundedBoxWithOutline.cornerRadius = Math.max(0.0f, this.config.backgroundStyles.roundedBoxWithOutline.cornerRadius);
        this.config.text.scale = Math.max(0.0f, this.config.text.scale);
        this.config.slidingText.scale = Math.max(0.0f, this.config.slidingText.scale);
        this.config.animText.scale = Math.max(0.0f, this.config.animText.scale);
        this.config.image.cornerRadius = Math.max(0.0f, this.config.image.cornerRadius);
        this.config.urlImage.cornerRadius = Math.max(0.0f, this.config.urlImage.cornerRadius);
    }

    public ThemeConfig getConfig() {
        return this.config;
    }

    public int getVersion() {
        return this.version;
    }

    public ThemeConfigUpdater(ThemeConfig config, int version, ConfigurationNode root) {
        this.config = config;
        this.version = version;
        this.root = root;
    }

    public boolean update() {
        if (this.version < 1) {
            return true;
        }
        this.parse();
        this.validate();
        return false;
    }
}

