/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.item;

import com.tttsaurus.ingameinfo.common.core.serialization.Deserializer;
import com.tttsaurus.ingameinfo.common.impl.serialization.ItemDeserializer;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Deserializer(value=ItemDeserializer.class)
public final class GhostableItem {
    private int meta;
    private ResourceLocation resourceLocation;
    private boolean isGhost;
    private boolean doesntExist;
    private ItemStack itemStack;

    public GhostableItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public GhostableItem(String registryName) {
        Item item;
        this.itemStack = null;
        String[] args = registryName.split(":");
        if (args.length <= 1 || args.length > 3) {
            this.doesntExist = true;
            return;
        }
        this.resourceLocation = new ResourceLocation(args[0], args[1]);
        this.meta = 0;
        if (args.length == 3) {
            try {
                this.meta = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(this.resourceLocation)) == null) {
            this.isGhost = true;
            return;
        }
        this.itemStack = new ItemStack(item, 1, this.meta);
    }

    @Nullable
    public ItemStack getItemStack() {
        Item item;
        if (this.doesntExist) {
            return null;
        }
        if (this.isGhost && (item = (Item)ForgeRegistries.ITEMS.getValue(this.resourceLocation)) != null) {
            this.isGhost = false;
            this.itemStack = new ItemStack(item, 1, this.meta);
        }
        if (this.itemStack == null) {
            return null;
        }
        return this.itemStack;
    }
}

