/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.compose;

import com.google.common.collect.ImmutableList;
import com.tttsaurus.ingameinfo.InGameInfoReborn;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Slot;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import java.util.ArrayList;

public final class ComposeValidator {
    private static ComposeValidator instance;
    private static boolean init;
    public final ImmutableList<String> validElementNames;
    public final ImmutableList<String> validElementGroupNames;

    protected static ComposeValidator getInstance() {
        ComposeValidator.init();
        return instance;
    }

    private ComposeValidator(ImmutableList<String> validElementNames, ImmutableList<String> validElementGroupNames) {
        this.validElementNames = validElementNames;
        this.validElementGroupNames = validElementGroupNames;
    }

    private static void init() {
        if (init) {
            return;
        }
        ArrayList<String> validElementNames = new ArrayList<String>();
        ArrayList<String> validElementGroupNames = new ArrayList<String>();
        for (Class<? extends Element> clazz : ElementRegistry.getConstructableElements()) {
            String name = clazz.getSimpleName();
            validElementNames.add(name);
            if (!ElementGroup.class.isAssignableFrom(clazz) || clazz.equals(Slot.class)) continue;
            validElementGroupNames.add(name);
        }
        instance = new ComposeValidator((ImmutableList<String>)ImmutableList.copyOf(validElementNames), (ImmutableList<String>)ImmutableList.copyOf(validElementGroupNames));
        init = true;
    }

    public boolean element(String name) {
        return this.validElementNames.contains((Object)name);
    }

    public boolean group(String name) {
        return this.validElementGroupNames.contains((Object)name);
    }

    public void error(String reason) {
        StringBuilder builder = new StringBuilder();
        builder.append("Compose Error: ").append(reason).append("\n");
        for (StackTraceElement stackTraceElement : new Exception().getStackTrace()) {
            builder.append('\t').append("at").append(' ').append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(')').append('\n');
        }
        InGameInfoReborn.LOGGER.error(builder.toString());
    }

    static {
        init = false;
    }
}

