/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render.shader.uniform;

import com.tttsaurus.ingameinfo.common.core.render.shader.uniform.UniformType;
import com.tttsaurus.ingameinfo.common.core.render.shader.uniform.Variant;
import net.minecraft.util.Tuple;

public final class UniformParseUtils {
    private static boolean isArray(String fieldName) {
        return fieldName.endsWith("]");
    }

    public static Tuple<UniformType, String> getUniformType(String rawType, String fieldName) {
        UniformType type = UniformType.UNKNOWN.deepClone();
        type.setSymbol(rawType);
        boolean array = false;
        if (UniformParseUtils.isArray(fieldName)) {
            int i;
            for (i = fieldName.length() - 2; i >= 0 && fieldName.charAt(i) != '['; --i) {
            }
            if (i > 0) {
                String lenArg = fieldName.substring(i + 1, fieldName.length() - 1);
                try {
                    int arrayLength = Integer.parseInt(lenArg);
                    array = true;
                    fieldName = fieldName.substring(0, i);
                    type = UniformType.ARRAY.deepClone().setArrayLength(arrayLength);
                }
                catch (Exception arrayLength) {
                    // empty catch block
                }
            }
        }
        for (UniformType uType : UniformType.TYPE_PRESET) {
            UniformType cloned = uType.deepClone();
            String symbol = cloned.getSymbol();
            if (rawType.equals(symbol)) {
                if (array) {
                    type.setSubType(cloned);
                } else {
                    type = cloned;
                }
                type.setSymbol(symbol);
                continue;
            }
            if (rawType.equals("i" + symbol)) {
                if (array) {
                    type.setSubType(cloned.setVariant(Variant.I)).setVariant(Variant.I);
                } else {
                    type = cloned.setVariant(Variant.I);
                }
                type.setSymbol(symbol);
                continue;
            }
            if (!rawType.equals("u" + symbol)) continue;
            if (array) {
                type.setSubType(cloned.setVariant(Variant.U)).setVariant(Variant.U);
            } else {
                type = cloned.setVariant(Variant.U);
            }
            type.setSymbol(symbol);
        }
        return new Tuple((Object)type, (Object)fieldName);
    }
}

