/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.serialization.ixml;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;

public final class RawIxmlUtils {
    public static List<Tuple<String, String>> extractNodes(String ixml) {
        ixml = ixml.trim();
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        int startIndex = 0;
        while (startIndex < ixml.length()) {
            char c = ixml.charAt(startIndex);
            while (startIndex + 1 < ixml.length() && (c == ' ' || c == '<')) {
                c = ixml.charAt(++startIndex);
            }
            if (startIndex == ixml.length() - 1) break;
            int endIndex = startIndex;
            while (endIndex + 1 < ixml.length() && c != ' ' && c != '>') {
                c = ixml.charAt(++endIndex);
            }
            String key = ixml.substring(startIndex, endIndex);
            int endIndex2 = endIndex;
            while (endIndex2 + 1 < ixml.length() && c != '>') {
                c = ixml.charAt(++endIndex2);
            }
            String value = endIndex2 > endIndex ? ixml.substring(endIndex + 1, endIndex2) : "";
            list.add((Tuple<String, String>)new Tuple((Object)key.trim(), (Object)value.trim()));
            startIndex = endIndex2 + 1;
        }
        return list;
    }

    public static List<Tuple<String, String>> splitParams(String param) {
        param = param.trim();
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        int startIndex = 0;
        while (startIndex < param.length()) {
            int braceCount;
            String value;
            int endIndex = startIndex;
            char c = param.charAt(endIndex);
            while (endIndex + 1 < param.length() && c != '=') {
                c = param.charAt(++endIndex);
            }
            if (endIndex == param.length() - 1) break;
            String key = param.substring(startIndex, endIndex);
            do {
                c = param.charAt(++endIndex);
            } while (endIndex + 1 < param.length() && c == ' ');
            int endIndex2 = endIndex;
            if (c == '\"') {
                endIndex2 = param.indexOf("\"", endIndex2 + 1);
                value = param.substring(endIndex + 1, endIndex2);
                ++endIndex2;
            } else if (c == '{') {
                braceCount = 1;
                ++endIndex2;
                while (endIndex2 < param.length() && braceCount > 0) {
                    c = param.charAt(endIndex2);
                    if (c == '{') {
                        ++braceCount;
                    } else if (c == '}') {
                        --braceCount;
                    }
                    ++endIndex2;
                }
                value = param.substring(endIndex, endIndex2);
            } else if (c == '[') {
                braceCount = 1;
                ++endIndex2;
                while (endIndex2 < param.length() && braceCount > 0) {
                    c = param.charAt(endIndex2);
                    if (c == '[') {
                        ++braceCount;
                    } else if (c == ']') {
                        --braceCount;
                    }
                    ++endIndex2;
                }
                value = param.substring(endIndex, endIndex2);
            } else {
                boolean func;
                boolean bl = func = c == '(';
                while (endIndex2 + 1 < param.length() && c != ' ' && !func) {
                    if ((c = param.charAt(++endIndex2)) != '(') continue;
                    func = true;
                }
                while (endIndex2 + 1 < param.length() && c != ')' && func) {
                    c = param.charAt(++endIndex2);
                }
                value = endIndex2 == param.length() - 1 || func ? param.substring(endIndex, endIndex2 + 1) : param.substring(endIndex, endIndex2);
                value = value.trim();
            }
            list.add((Tuple<String, String>)new Tuple((Object)key.trim(), (Object)value));
            startIndex = endIndex2 + 1;
        }
        return list;
    }

    public static String deleteComments(String ixml) {
        ixml = ixml.trim();
        ArrayList<Integer> startIndices = new ArrayList<Integer>();
        ArrayList<Integer> endIndices = new ArrayList<Integer>();
        int layer = 0;
        for (int index = 0; index < ixml.length(); ++index) {
            if (ixml.startsWith("<!--", index) && layer == 0) {
                startIndices.add(index);
                ++layer;
            }
            if (!ixml.startsWith("-->", index) || layer != 1) continue;
            endIndices.add(index + 2);
            --layer;
        }
        int offset = 0;
        String res = ixml;
        for (int i = 0; i < startIndices.size(); ++i) {
            if (i + 1 > endIndices.size()) continue;
            res = res.substring(0, (Integer)startIndices.get(i) - offset) + res.substring((Integer)endIndices.get(i) + 1 - offset);
            offset += (Integer)endIndices.get(i) - (Integer)startIndices.get(i) + 1;
        }
        return res;
    }
}

