/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.appcommunication.spotify;

import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyAccessUtils;
import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyOAuthUtils;
import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyUserInfo;
import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.TrackPlaying;
import com.tttsaurus.ingameinfo.common.core.commonutils.FileUtils;
import com.tttsaurus.ingameinfo.common.core.gui.event.IUIEventListener;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEventListenerType;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Padding;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.impl.appcommunication.spotify.SpotifyView;
import com.tttsaurus.ingameinfo.common.impl.igievent.EventCenter;
import com.tttsaurus.ingameinfo.config.IgiSpotifyIntegrationConfig;
import java.io.RandomAccessFile;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class SpotifyViewModel
extends ViewModel<SpotifyView> {
    @Reactive(targetUid="albumImageGroup", property="padding", initiativeSync=true)
    public ReactiveObject<Padding> albumImageGroupPadding = new ReactiveObject<Padding>(){};
    @Reactive(targetUid="albumImage", property="url", initiativeSync=true)
    public ReactiveObject<String> albumImageUrl = new ReactiveObject<String>(){};
    @Reactive(targetUid="albumImage", property="width", initiativeSync=true)
    public ReactiveObject<Float> albumImageWidth = new ReactiveObject<Float>(){};
    @Reactive(targetUid="albumImage", property="height", initiativeSync=true)
    public ReactiveObject<Float> albumImageHeight = new ReactiveObject<Float>(){};
    @Reactive(targetUid="albumImage", property="padding", initiativeSync=true)
    public ReactiveObject<Padding> albumImagePadding = new ReactiveObject<Padding>(){};
    @Reactive(targetUid="trackTitleGroup", property="enabled", initiativeSync=true)
    public ReactiveObject<Boolean> trackTitleGroupEnabled = new ReactiveObject<Boolean>(){};
    @Reactive(targetUid="trackTitle", property="text", initiativeSync=true)
    public ReactiveObject<String> trackTitleText = new ReactiveObject<String>(){};
    @Reactive(targetUid="trackTitle", property="xShiftSpeed", initiativeSync=true)
    public ReactiveObject<Float> trackTitleXShiftSpeed = new ReactiveObject<Float>(){};
    @Reactive(targetUid="progressBarGroup", property="padding", initiativeSync=true)
    public ReactiveObject<Padding> progressBarGroupPadding = new ReactiveObject<Padding>(){};
    @Reactive(targetUid="progressBar", property="percentage", initiativeSync=true)
    public ReactiveObject<Float> progressBarPercentage = new ReactiveObject<Float>(){};
    @Reactive(targetUid="progressBar", property="width", initiativeSync=true)
    public ReactiveObject<Float> progressBarWidth = new ReactiveObject<Float>(){};
    @Reactive(targetUid="anotherTrackTitleGroup", property="enabled", initiativeSync=true)
    public ReactiveObject<Boolean> anotherTrackTitleGroupEnabled = new ReactiveObject<Boolean>(){};
    @Reactive(targetUid="anotherTrackTitle", property="text", initiativeSync=true)
    public ReactiveObject<String> anotherTrackTitleText = new ReactiveObject<String>(){};
    @Reactive(targetUid="anotherTrackTitle", property="xShiftSpeed", initiativeSync=true)
    public ReactiveObject<Float> anotherTrackTitleXShiftSpeed = new ReactiveObject<Float>(){};
    @Reactive(targetUid="anotherTrackAuthor", property="text", initiativeSync=true)
    public ReactiveObject<String> anotherTrackAuthorText = new ReactiveObject<String>(){};
    @Reactive(targetUid="anotherTrackTimer", property="text", initiativeSync=true)
    public ReactiveObject<String> anotherTrackTimerText = new ReactiveObject<String>(){};
    @Reactive(targetUid="editButton", property="enabled", initiativeSync=true)
    public ReactiveObject<Boolean> editButtonEnabled = new ReactiveObject<Boolean>(){};
    private float durationMs = 0.0f;
    private float estimatedProgressMs;
    private boolean isPlaying = false;
    private float refreshTokenTimer = 0.0f;
    private float refreshTrackTimer = 0.0f;

    private void refreshTokenIfNeeded() {
        long timeSpan = Duration.between(SpotifyUserInfo.token.start, LocalDateTime.now()).getSeconds();
        if (timeSpan >= (long)(SpotifyUserInfo.token.expiresIn - 10)) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    SpotifyOAuthUtils.refreshAccessToken(SpotifyUserInfo.token);
                }
                catch (Exception e) {
                    SpotifyUserInfo.token.accessToken = "";
                }
                return null;
            });
        }
    }

    private void refreshTokenIfNeeded(Runnable asyncThen) {
        long timeSpan = Duration.between(SpotifyUserInfo.token.start, LocalDateTime.now()).getSeconds();
        if (timeSpan >= (long)(SpotifyUserInfo.token.expiresIn - 10)) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    SpotifyOAuthUtils.refreshAccessToken(SpotifyUserInfo.token);
                }
                catch (Exception e) {
                    SpotifyUserInfo.token.accessToken = "";
                }
                return null;
            }).thenRun(asyncThen);
        } else {
            CompletableFuture.supplyAsync(() -> {
                asyncThen.run();
                return null;
            });
        }
    }

    private void refreshTrackInfo() {
        CompletableFuture.supplyAsync(() -> {
            try {
                TrackPlaying trackPlaying = SpotifyAccessUtils.getCurrentlyPlaying(SpotifyUserInfo.token.accessToken);
                if (trackPlaying.trackExists) {
                    this.trackTitleXShiftSpeed.set(Float.valueOf(8.0f));
                    if (!this.albumImageUrl.get().equals(trackPlaying.albumImage300by300)) {
                        this.albumImageUrl.set(trackPlaying.albumImage300by300);
                    }
                    if (!this.trackTitleText.get().equals(trackPlaying.trackName)) {
                        this.trackTitleText.set(trackPlaying.trackName);
                    }
                    float percentage = 0.0f;
                    if (trackPlaying.durationMs != 0) {
                        percentage = (float)trackPlaying.progressMs / (float)trackPlaying.durationMs;
                    }
                    this.progressBarPercentage.set(Float.valueOf(percentage));
                    this.durationMs = trackPlaying.durationMs;
                    this.estimatedProgressMs = trackPlaying.progressMs;
                    this.isPlaying = trackPlaying.isPlaying;
                    this.anotherTrackTitleXShiftSpeed.set(Float.valueOf(8.0f));
                    if (!this.anotherTrackTitleText.get().equals(trackPlaying.trackName)) {
                        this.anotherTrackTitleText.set(trackPlaying.trackName);
                    }
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < trackPlaying.artists.size(); ++i) {
                        builder.append(trackPlaying.artists.get(i));
                        if (i == trackPlaying.artists.size() - 1) continue;
                        builder.append(", ");
                    }
                    String authors = builder.toString();
                    if (!this.anotherTrackAuthorText.get().equals(authors)) {
                        this.anotherTrackAuthorText.set(authors);
                    }
                    this.anotherTrackTimerText.set(this.calcTimeText(percentage));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    private String calcTimeText(float percentage) {
        int totalSeconds = (int)this.durationMs / 1000;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String time = String.format("%d:%02d", minutes, seconds);
        totalSeconds = (int)(percentage * (float)totalSeconds);
        minutes = totalSeconds / 60;
        seconds = totalSeconds % 60;
        time = String.format("%d:%02d", minutes, seconds) + " / " + time;
        return time;
    }

    private void switchLayout() {
        if (IgiSpotifyIntegrationConfig.SPOTIFY_EXTENDED_LAYOUT) {
            this.trackTitleGroupEnabled.set(false);
            this.albumImageGroupPadding.set(new Padding(5.0f, 5.0f, 0.0f, 0.0f));
            this.albumImageWidth.set(Float.valueOf(60.0f));
            this.albumImageHeight.set(Float.valueOf(60.0f));
            this.albumImagePadding.set(new Padding(0.0f, 0.0f, 5.0f, 5.0f));
            this.progressBarGroupPadding.set(new Padding(0.0f, 5.0f, 0.0f, 0.0f));
            this.progressBarWidth.set(Float.valueOf(115.0f));
            this.anotherTrackTitleGroupEnabled.set(true);
        } else {
            this.trackTitleGroupEnabled.set(true);
            this.albumImageGroupPadding.set(new Padding(10.0f, 5.0f, 0.0f, 0.0f));
            this.albumImageWidth.set(Float.valueOf(40.0f));
            this.albumImageHeight.set(Float.valueOf(40.0f));
            this.albumImagePadding.set(new Padding(0.0f, 0.0f, 10.0f, 10.0f));
            this.progressBarGroupPadding.set(new Padding(0.0f, 10.0f, 0.0f, 0.0f));
            this.progressBarWidth.set(Float.valueOf(50.0f));
            this.anotherTrackTitleGroupEnabled.set(false);
        }
    }

    @Override
    public void onStart() {
        this.setActive(false);
        this.setExitCallback(() -> {
            this.editButtonEnabled.set(false);
            this.setFocused(false);
            return false;
        });
        this.albumImageUrl.set("");
        this.progressBarPercentage.set(Float.valueOf(0.0f));
        this.switchLayout();
        this.bindEventListener("editButton", UIEvent.MouseRelease.class, new IUIEventListener<UIEvent.MouseRelease>(){

            @Override
            public void handle(UIEvent.MouseRelease event) {
                if (IgiSpotifyIntegrationConfig.SPOTIFY_EXTENDED_LAYOUT) {
                    IgiSpotifyIntegrationConfig.useSpotifyExtendedLayout(false);
                    SpotifyViewModel.this.switchLayout();
                } else {
                    IgiSpotifyIntegrationConfig.useSpotifyExtendedLayout(true);
                    SpotifyViewModel.this.switchLayout();
                }
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.TARGET;
            }
        });
        EventCenter.spotifyOverlayEvent.addListener(flag -> {
            if (flag.booleanValue()) {
                if (SpotifyUserInfo.token.accessToken.isEmpty()) {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " The access token is empty."));
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "[SpotifyBot]" + TextFormatting.RESET + " Please run the command #spotify-oauth first."));
                    }
                    return;
                }
                this.setActive(true);
                this.trackTitleXShiftSpeed.set(Float.valueOf(20.0f));
                this.trackTitleText.set("Please wait... And make sure you play a track on Spotify");
                this.anotherTrackTitleXShiftSpeed.set(Float.valueOf(20.0f));
                this.anotherTrackTitleText.set("Please wait... And make sure you play a track on Spotify");
                this.anotherTrackAuthorText.set("");
                this.anotherTrackTimerText.set("");
                this.refreshTokenIfNeeded(() -> {
                    try {
                        TrackPlaying trackPlaying = SpotifyAccessUtils.getCurrentlyPlaying(SpotifyUserInfo.token.accessToken);
                        if (trackPlaying.trackExists) {
                            this.trackTitleXShiftSpeed.set(Float.valueOf(8.0f));
                            this.albumImageUrl.set(trackPlaying.albumImage300by300);
                            this.trackTitleText.set(trackPlaying.trackName);
                            float percentage = 0.0f;
                            if (trackPlaying.durationMs != 0) {
                                percentage = (float)trackPlaying.progressMs / (float)trackPlaying.durationMs;
                            }
                            this.progressBarPercentage.set(Float.valueOf(percentage));
                            this.durationMs = trackPlaying.durationMs;
                            this.estimatedProgressMs = trackPlaying.progressMs;
                            this.isPlaying = trackPlaying.isPlaying;
                            this.anotherTrackTitleXShiftSpeed.set(Float.valueOf(8.0f));
                            this.anotherTrackTitleText.set(trackPlaying.trackName);
                            StringBuilder builder = new StringBuilder();
                            for (int i = 0; i < trackPlaying.artists.size(); ++i) {
                                builder.append(trackPlaying.artists.get(i));
                                if (i == trackPlaying.artists.size() - 1) continue;
                                builder.append(", ");
                            }
                            this.anotherTrackAuthorText.set(builder.toString());
                            this.anotherTrackTimerText.set(this.calcTimeText(percentage));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            } else {
                this.setActive(false);
            }
        });
        EventCenter.spotifyOverlayEditEvent.addListener(() -> {
            if (this.getActive()) {
                this.editButtonEnabled.set(true);
                this.setFocused(true);
            }
        });
        try {
            RandomAccessFile file = new RandomAccessFile(FileUtils.getFile("spotify_refresh_token.txt", "cache"), "rw");
            StringBuilder builder = new StringBuilder();
            String line = file.readLine();
            while (line != null) {
                builder.append(line);
                line = file.readLine();
            }
            file.close();
            String refreshToken = builder.toString();
            if (!refreshToken.isEmpty()) {
                SpotifyUserInfo.token.refreshToken = refreshToken;
                CompletableFuture.supplyAsync(() -> {
                    boolean success = false;
                    try {
                        SpotifyOAuthUtils.refreshAccessToken(SpotifyUserInfo.token);
                        success = true;
                    }
                    catch (Exception e) {
                        SpotifyUserInfo.token.accessToken = "";
                    }
                    if (success) {
                        try {
                            SpotifyUserInfo.userName = SpotifyAccessUtils.getUserName(SpotifyUserInfo.token.accessToken);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (IgiSpotifyIntegrationConfig.SPOTIFY_AUTO_DISPLAY) {
                            EventCenter.spotifyOverlayEvent.trigger(true);
                        }
                    }
                    return null;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
        this.refreshTokenTimer += (float)deltaTime;
        if (this.refreshTokenTimer > 5.0f) {
            this.refreshTokenTimer -= 5.0f;
            this.refreshTokenIfNeeded();
        }
        this.refreshTrackTimer += (float)deltaTime;
        if (this.refreshTrackTimer > 3.0f) {
            this.refreshTrackTimer -= 3.0f;
            this.refreshTrackInfo();
        }
        if (this.progressBarPercentage.get().floatValue() < 1.0f && this.isPlaying) {
            int timeMs = (int)(deltaTime * 1000.0);
            this.estimatedProgressMs += (float)timeMs;
            if (this.durationMs != 0.0f) {
                if (this.estimatedProgressMs >= this.durationMs) {
                    this.estimatedProgressMs = this.durationMs;
                    this.refreshTrackTimer = 1.5f;
                }
                float percentage = this.estimatedProgressMs / this.durationMs;
                this.progressBarPercentage.set(Float.valueOf(percentage));
                String timeText = this.calcTimeText(percentage);
                if (!this.anotherTrackTimerText.get().equals(timeText)) {
                    this.anotherTrackTimerText.set(timeText);
                }
            }
        }
    }
}

