/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Sized;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.Texture2D;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.ImageOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

@RegisterElement
public class Image
extends Sized {
    private Texture2D texture = null;
    @StyleProperty
    public boolean rounded;
    @StyleProperty(setterCallbackPost="setRlCallback", setterCallbackPre="rlValidation")
    public String rl;

    @StylePropertyCallback
    public void rlValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setRlCallback() {
        ResourceLocation resourceLocation = new ResourceLocation(this.rl);
        if (this.texture != null) {
            this.texture.dispose();
        }
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            InputStream inputStream = resource.func_110527_b();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            this.texture = RenderUtils.createTexture2D(bufferedImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        queue.enqueue(new ImageOp(this.rect, this.texture, this.rounded));
    }
}

