/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.layout;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.MaskEndOp;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.MaskStartOp;

@RegisterElement
public class SizedGroup
extends ElementGroup {
    @StyleProperty
    public boolean useMask = true;
    @StyleProperty
    public boolean isMaskRounded = false;
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="nonNegativeFloatValidation")
    public float width;
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="nonNegativeFloatValidation")
    public float height;

    @StylePropertyCallback
    public void nonNegativeFloatValidation(float value, CallbackInfo callbackInfo) {
        if (value < 0.0f) {
            callbackInfo.cancel = true;
        }
    }

    @Override
    public void calcRenderPos(Rect contextRect) {
        super.calcRenderPos(contextRect);
        if (this.elements.isEmpty()) {
            return;
        }
        for (Element element : this.elements) {
            element.rect.x = this.rect.x + this.rect.width * element.alignment.vertical;
            element.rect.y = this.rect.y + this.rect.height * element.alignment.horizontal;
            if (element.pivot.vertical == 0.0f || element.pivot.vertical == 0.5f) {
                element.rect.x += element.padding.left;
            }
            if (element.pivot.vertical == 1.0f || element.pivot.vertical == 0.5f) {
                element.rect.x -= element.padding.right;
            }
            if (element.pivot.horizontal == 0.0f || element.pivot.horizontal == 0.5f) {
                element.rect.y += element.padding.top;
            }
            if (element.pivot.horizontal == 1.0f || element.pivot.horizontal == 0.5f) {
                element.rect.y -= element.padding.bottom;
            }
            element.calcRenderPos(this.rect);
        }
    }

    @Override
    public void calcWidthHeight() {
        super.calcWidthHeight();
        this.rect.width = this.width;
        this.rect.height = this.height;
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        if (!this.enabled) {
            return;
        }
        if (this.useMask) {
            if (this.isMaskRounded) {
                queue.enqueue(new MaskStartOp(this.rect, 3.0f));
            } else {
                queue.enqueue(new MaskStartOp(this.rect));
            }
        }
        super.onRenderUpdate(queue, focused);
        if (this.useMask) {
            queue.enqueue(new MaskEndOp());
        }
    }
}

