/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderMask;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;

public class ProgressBarOp
implements IRenderOp {
    public Rect rect;
    public float percentage;
    public int backgroundColor;
    public int fillerColor;
    public int outlineColor;

    public ProgressBarOp(Rect rect, float percentage, int backgroundColor, int fillerColor, int outlineColor) {
        this.rect = rect;
        this.percentage = percentage;
        this.backgroundColor = backgroundColor;
        this.fillerColor = fillerColor;
        this.outlineColor = outlineColor;
    }

    @Override
    public void readTheme(ThemeConfig theme) {
        if (this.fillerColor == 0) {
            this.fillerColor = theme.progressBar.parsedFillerColor;
        }
        if (this.backgroundColor == 0) {
            this.backgroundColor = theme.progressBar.parsedBackgroundColor;
        }
        if (this.outlineColor == 0) {
            this.outlineColor = theme.progressBar.parsedOutlineColor;
        }
    }

    @Override
    public void execute(RenderContext context) {
        RenderUtils.renderRoundedRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.rect.height / 2.0f, this.backgroundColor, context.polygonSmoothHint);
        if (this.percentage != 0.0f) {
            RenderMask mask = new RenderMask(RenderMask.MaskShape.ROUNDED_RECT);
            mask.setRoundedRectMask(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.rect.height / 2.0f);
            mask.startMasking();
            RenderUtils.renderRect(this.rect.x, this.rect.y, this.rect.width * this.percentage, this.rect.height, this.fillerColor);
            RenderMask.endMasking();
        }
        RenderUtils.renderRoundedRectOutline(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.rect.height / 2.0f, 1.0f, this.outlineColor, context.lineSmoothHint);
    }
}

