/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.demo.eg1;

import com.tttsaurus.ingameinfo.common.core.gui.event.IUIEventListener;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEventListenerType;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveCollection;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.SlotAccessor;
import com.tttsaurus.ingameinfo.common.core.mvvm.context.ContextKey;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.impl.igievent.EventCenter;
import com.tttsaurus.ingameinfo.demo.eg1.Eg1Compose;
import com.tttsaurus.ingameinfo.demo.eg1.Eg1View;

public class Eg1ViewModel
extends ViewModel<Eg1View> {
    @Reactive(targetUid="tps/mspt", property="text", initiativeSync=true)
    public ReactiveObject<String> tpsMtpsText = new ReactiveObject<String>(){};
    @Reactive(targetUid="memoryBar", property="percentage", initiativeSync=true)
    public ReactiveObject<Float> memoryBarPercentage = new ReactiveObject<Float>(){};
    @Reactive(targetUid="memory", property="text", initiativeSync=true)
    public ReactiveObject<String> memoryText = new ReactiveObject<String>(){};
    @Reactive(targetUid="list")
    public ReactiveCollection list = new ReactiveCollection();
    @Reactive(targetUid="mySlot")
    public SlotAccessor slot = new SlotAccessor();
    private boolean flag = false;
    private int counter = 0;

    @Override
    public void onStart() {
        EventCenter.gameTpsMsptEvent.addListener((tps, mspt) -> this.tpsMtpsText.set(String.format("TPS: %d, MSPT: %.3f ms/t", tps, mspt)));
        EventCenter.gameMemoryEvent.addListener((used, total) -> {
            int usedMb = (int)(used / 1024L / 1024L);
            int totalMb = (int)(total / 1024L / 1024L);
            this.memoryBarPercentage.set(Float.valueOf((float)usedMb / (float)totalMb));
            this.memoryText.set(usedMb + " MB / " + totalMb + " MB");
        });
        this.bindEventListener("switch", UIEvent.MouseRelease.class, new IUIEventListener<UIEvent.MouseRelease>(){

            @Override
            public void handle(UIEvent.MouseRelease event) {
                Eg1ViewModel.this.sharedContext.put(ContextKey.gen("num", Integer.TYPE), ++Eg1ViewModel.this.counter);
                if (Eg1ViewModel.this.flag) {
                    Eg1ViewModel.this.list.get(0).set("enabled", false);
                    Eg1ViewModel.this.list.get(1).set("enabled", true);
                } else {
                    Eg1ViewModel.this.list.get(1).set("enabled", false);
                    Eg1ViewModel.this.list.get(0).set("enabled", true);
                }
                Eg1ViewModel.this.flag = !Eg1ViewModel.this.flag;
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.TARGET;
            }
        });
        this.slot.initComposeBlock(Eg1Compose.class);
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
    }
}

