/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.plugin.crt.impl;

import crafttweaker.annotations.ZenRegister;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ingameinfo.utils.CommonUtils")
public final class CommonUtils {
    @ZenMethod
    public static String alignStringToRight(String value, int expectLength) {
        if (value.length() < expectLength) {
            StringBuilder builder = new StringBuilder();
            int compensate = expectLength - value.length();
            for (int i = 0; i < compensate; ++i) {
                builder.append(" ");
            }
            builder.append(value);
            return builder.toString();
        }
        return value;
    }

    @ZenMethod
    public static String alignStringToLeft(String value, int expectLength) {
        if (value.length() < expectLength) {
            StringBuilder builder = new StringBuilder();
            builder.append(value);
            int compensate = expectLength - value.length();
            for (int i = 0; i < compensate; ++i) {
                builder.append(" ");
            }
            return builder.toString();
        }
        return value;
    }

    @ZenMethod
    public static float truncateFloat(float value, int decimalPlaces) {
        float multiplier = (float)Math.pow(10.0, decimalPlaces);
        return (float)((int)(value * multiplier)) / multiplier;
    }

    @ZenMethod
    public static double truncateDouble(double value, int decimalPlaces) {
        double multiplier = Math.pow(10.0, decimalPlaces);
        return (double)((long)(value * multiplier)) / multiplier;
    }

    @ZenMethod
    public static int toInt(Object value) {
        Class<?> clazz = value.getClass();
        int output = 0;
        if (clazz == Integer.class) {
            output = (Integer)value;
        } else if (clazz == Long.class) {
            output = (int)((Long)value).longValue();
        } else if (clazz == Short.class) {
            output = ((Short)value).shortValue();
        } else if (clazz == Double.class) {
            output = (int)((Double)value).doubleValue();
        } else if (clazz == Float.class) {
            output = (int)((Float)value).floatValue();
        } else if (clazz == Character.class) {
            output = ((Character)value).charValue();
        } else if (clazz == Boolean.class) {
            output = (Boolean)value != false ? 1 : 0;
        } else if (clazz == String.class) {
            output = CommonUtils.toInt((String)value);
        }
        return output;
    }

    @ZenMethod
    public static int toInt(int value) {
        return value;
    }

    @ZenMethod
    public static int toInt(long value) {
        return (int)value;
    }

    @ZenMethod
    public static int toInt(short value) {
        return value;
    }

    @ZenMethod
    public static int toInt(double value) {
        return (int)value;
    }

    @ZenMethod
    public static int toInt(float value) {
        return (int)value;
    }

    @ZenMethod
    public static int toInt(char value) {
        return value;
    }

    @ZenMethod
    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    @ZenMethod
    public static int toInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    @ZenMethod
    public static float toFloat(Object value) {
        Class<?> clazz = value.getClass();
        float output = 0.0f;
        if (clazz == Integer.class) {
            output = ((Integer)value).intValue();
        } else if (clazz == Long.class) {
            output = (int)((Long)value).longValue();
        } else if (clazz == Short.class) {
            output = ((Short)value).shortValue();
        } else if (clazz == Double.class) {
            output = (float)((Double)value).doubleValue();
        } else if (clazz == Float.class) {
            output = ((Float)value).floatValue();
        } else if (clazz == Character.class) {
            output = ((Character)value).charValue();
        } else if (clazz == Boolean.class) {
            output = (Boolean)value != false ? 1.0f : 0.0f;
        } else if (clazz == String.class) {
            output = CommonUtils.toFloat((String)value);
        }
        return output;
    }

    @ZenMethod
    public static float toFloat(int value) {
        return value;
    }

    @ZenMethod
    public static float toFloat(long value) {
        return (int)value;
    }

    @ZenMethod
    public static float toFloat(short value) {
        return value;
    }

    @ZenMethod
    public static float toFloat(double value) {
        return (float)value;
    }

    @ZenMethod
    public static float toFloat(float value) {
        return value;
    }

    @ZenMethod
    public static float toFloat(char value) {
        return value;
    }

    @ZenMethod
    public static float toFloat(boolean value) {
        return value ? 1.0f : 0.0f;
    }

    @ZenMethod
    public static float toFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ignored) {
            return 0.0f;
        }
    }

    @ZenMethod
    public static String toString(Object value) {
        return value.toString();
    }

    @ZenMethod
    public static String toString(int value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(long value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(short value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(double value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(float value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(char value) {
        return String.valueOf(value);
    }

    @ZenMethod
    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    @ZenMethod
    public static Object toObject(Object value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(String value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(int value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(long value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(short value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(double value) {
        return value;
    }

    @ZenMethod
    public static Object toObject(float value) {
        return Float.valueOf(value);
    }

    @ZenMethod
    public static Object toObject(char value) {
        return Character.valueOf(value);
    }

    @ZenMethod
    public static Object toObject(boolean value) {
        return value;
    }

    @ZenRegister
    @ZenClass(value="mods.ingameinfo.utils.AtomicInteger")
    public static class AtomicInteger {
        private final java.util.concurrent.atomic.AtomicInteger atomicInteger = new java.util.concurrent.atomic.AtomicInteger();

        @ZenMethod
        public void set(int value) {
            this.atomicInteger.set(value);
        }

        @ZenMethod
        public int get() {
            return this.atomicInteger.get();
        }

        @ZenMethod(value="new")
        public static AtomicInteger newAtomicInteger(int value) {
            AtomicInteger instance = new AtomicInteger();
            instance.set(value);
            return instance;
        }
    }

    @ZenRegister
    @ZenClass(value="mods.ingameinfo.utils.AtomicBoolean")
    public static class AtomicBoolean {
        private final java.util.concurrent.atomic.AtomicBoolean atomicBoolean = new java.util.concurrent.atomic.AtomicBoolean();

        @ZenMethod
        public void set(boolean value) {
            this.atomicBoolean.set(value);
        }

        @ZenMethod
        public boolean get() {
            return this.atomicBoolean.get();
        }

        @ZenMethod(value="new")
        public static AtomicBoolean newAtomicBoolean(boolean value) {
            AtomicBoolean instance = new AtomicBoolean();
            instance.set(value);
            return instance;
        }
    }
}

