/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.tttsaurus.ingameinfo.common.core.IgiRuntime;
import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.appcommunication.spotify.SpotifyOAuthUtils;
import com.tttsaurus.ingameinfo.common.core.commonutils.FileUtils;
import com.tttsaurus.ingameinfo.common.core.forgeevent.IgiRuntimeEntryPointEvent;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLifecycleProvider;
import com.tttsaurus.ingameinfo.common.core.gui.GuiResources;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.ILerpablePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpTarget;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyCallbackPost;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyCallbackPre;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySetter;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import com.tttsaurus.ingameinfo.common.core.gui.theme.registry.ThemeRegistry;
import com.tttsaurus.ingameinfo.common.core.reflection.TypeUtils;
import com.tttsaurus.ingameinfo.common.core.render.GlResourceManager;
import com.tttsaurus.ingameinfo.common.core.render.RenderHints;
import com.tttsaurus.ingameinfo.common.core.serialization.IDeserializer;
import com.tttsaurus.ingameinfo.common.core.shutdown.ShutdownHooks;
import com.tttsaurus.ingameinfo.common.impl.IgiRuntimeEntryPoint;
import com.tttsaurus.ingameinfo.common.impl.appcommunication.spotify.SpotifyCommandHandler;
import com.tttsaurus.ingameinfo.common.impl.gui.DefaultLifecycleProvider;
import com.tttsaurus.ingameinfo.common.impl.mvvm.command.RefreshVvmCommand;
import com.tttsaurus.ingameinfo.config.IgiCommonConfig;
import com.tttsaurus.ingameinfo.config.IgiDefaultLifecycleProviderConfig;
import com.tttsaurus.ingameinfo.config.IgiSpotifyIntegrationConfig;
import com.tttsaurus.ingameinfo.proxy.CommonProxy;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Logger;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event, Logger logger) {
        super.preInit(event, logger);
        int majorGlVersion = RenderHints.getMajorGlVersion();
        int minorGlVersion = RenderHints.getMinorGlVersion();
        logger.info("Raw OpenGL version: " + RenderHints.getRawGlVersion());
        logger.info(String.format("OpenGL version: %d.%d", majorGlVersion, minorGlVersion));
        RenderHints.getModelViewMatrix();
        logger.info("The getters of ActiveRenderInfo private fields are ready.");
        RenderHints.getPartialTick();
        logger.info("The getter of private partial tick field is ready.");
        GuiLifecycleProvider guiLifecycleProvider = IgiCommonConfig.GUI_LIFECYCLE_PROVIDER;
        if (guiLifecycleProvider instanceof DefaultLifecycleProvider) {
            DefaultLifecycleProvider provider = (DefaultLifecycleProvider)guiLifecycleProvider;
            logger.info("Default GUI Lifecycle Provider is in use.");
            boolean enableFbo = IgiDefaultLifecycleProviderConfig.ENABLE_FRAMEBUFFER && OpenGlHelper.field_148823_f;
            boolean enablePostProcessing = IgiDefaultLifecycleProviderConfig.ENABLE_POST_PROCESSING_SHADER && (majorGlVersion == 3 && minorGlVersion >= 3 || majorGlVersion > 3);
            boolean enableMsfbo = IgiDefaultLifecycleProviderConfig.ENABLE_MSFRAMEBUFFER && majorGlVersion >= 4;
            enablePostProcessing = enableFbo && enablePostProcessing;
            enableMsfbo = enableFbo && enableMsfbo;
            logger.info("Default GUI Lifecycle Provider: Framebuffer is " + (enableFbo ? "ON" : "OFF"));
            logger.info("Default GUI Lifecycle Provider: Post-Processing on framebuffer is " + (enablePostProcessing ? "ON" : "OFF") + " (requires GL33 and framebuffer)");
            logger.info("Default GUI Lifecycle Provider: Multisampling on framebuffer is " + (enableMsfbo ? "ON" : "OFF") + " (requires GL40 and framebuffer)");
            provider.setEnableFbo(enableFbo);
            provider.setEnableShader(enablePostProcessing);
            provider.setEnableMultisampleOnFbo(enableMsfbo);
            RenderHints.fboSampleNum(IgiDefaultLifecycleProviderConfig.FRAMEBUFFER_SAMPLE_NUM);
        } else {
            logger.info("Default GUI Lifecycle Provider is not in use.");
        }
        IgiCommonConfig.GUI_LIFECYCLE_PROVIDER.setMaxFps_FixedUpdate(IgiCommonConfig.FIXED_UPDATE_LIMIT);
        IgiCommonConfig.GUI_LIFECYCLE_PROVIDER.setMaxFps_RenderUpdate(IgiCommonConfig.RENDER_UPDATE_LIMIT);
        logger.info("GUI Lifecycle Provider is ready.");
        if (IgiSpotifyIntegrationConfig.ENABLE_SPOTIFY_INTEGRATION) {
            SpotifyOAuthUtils.CLIENT_ID = IgiSpotifyIntegrationConfig.SPOTIFY_CLIENT_ID;
            SpotifyOAuthUtils.CLIENT_SECRET = IgiSpotifyIntegrationConfig.SPOTIFY_CLIENT_SECRET;
        }
    }

    @Override
    public void init(FMLInitializationEvent event, Logger logger) {
        super.init(event, logger);
        ShutdownHooks.hooks.add(() -> {
            logger.info("Start disposing OpenGL resources");
            GlResourceManager.disposeAll(logger);
            logger.info("OpenGL resources disposed");
        });
        logger.info("Shutdown hooks setup finished.");
        MinecraftForge.EVENT_BUS.register(IgiRuntimeEntryPoint.class);
        MinecraftForge.EVENT_BUS.register(ThemeRegistry.class);
        logger.info("Core event listeners registered.");
        if (IgiSpotifyIntegrationConfig.ENABLE_SPOTIFY_INTEGRATION) {
            MinecraftForge.EVENT_BUS.register(SpotifyCommandHandler.class);
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new RefreshVvmCommand());
        logger.info("Client commands registered.");
        GuiResources.init();
        logger.info("GUI resources loaded.");
        ThemeRegistry.init();
        logger.info("Theme configs loaded. They are: " + String.join((CharSequence)", ", ThemeRegistry.getThemeNames()));
        String myPackage = "com.tttsaurus.ingameinfo";
        ElementRegistry.register();
        logger.info("UI elements registered. See config/ingameinfo/ui_element_dump.md");
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append("## Notice:\n");
        builder.append("1. Elements marked with `*` below are abstract (unserviceable in ixml).\n");
        builder.append("2. You can access style properties from parent elements.\n");
        builder.append("\n");
        ImmutableList<Class<? extends Element>> elementClasses = ElementRegistry.getRegisteredElements();
        List<Class<? extends Element>> constructableElements = ElementRegistry.getConstructableElements();
        builder.append("## Registered Elements:\n");
        for (Class clazz : elementClasses) {
            builder.append("- `").append(TypeUtils.isFromParentPackage(clazz, myPackage) ? clazz.getSimpleName() : clazz.getName()).append(constructableElements.contains(clazz) ? "" : "*").append("`\n");
        }
        builder.append("\n").append("## Details:\n\n");
        ImmutableMap<String, Map<String, IStylePropertySetter>> setters = ElementRegistry.getStylePropertySetters();
        ImmutableMap<IStylePropertySetter, IDeserializer<?>> deserializers = ElementRegistry.getStylePropertyDeserializers();
        ImmutableMap<IStylePropertySetter, IStylePropertyCallbackPre> setterCallbacksPre = ElementRegistry.getStylePropertySetterCallbacksPre();
        ImmutableMap<IStylePropertySetter, IStylePropertyCallbackPost> setterCallbacksPost = ElementRegistry.getStylePropertySetterCallbacksPost();
        ImmutableMap<IStylePropertySetter, Class<?>> classes = ElementRegistry.getStylePropertyClasses();
        ImmutableMap<String, Map<ILerpablePropertyGetter, LerpTarget>> getters = ElementRegistry.getLerpablePropertyGetters();
        int count = elementClasses.size();
        int index = 0;
        for (Class clazz : elementClasses) {
            Map map2;
            String parentMsg = "";
            if (!clazz.equals(Element.class)) {
                parentMsg = " extends `" + (TypeUtils.isFromParentPackage(clazz.getSuperclass(), myPackage) ? clazz.getSuperclass().getSimpleName() : clazz.getSuperclass().getName()) + (constructableElements.contains(clazz.getSuperclass()) ? "" : "*") + "`";
            }
            builder.append("**Element Type**: `").append(TypeUtils.isFromParentPackage(clazz, myPackage) ? clazz.getSimpleName() : clazz.getName()).append(constructableElements.contains(clazz) ? "" : "*").append("`").append(parentMsg).append("\n");
            Map map1 = (Map)setters.get((Object)clazz.getName());
            if (!map1.isEmpty()) {
                builder.append("- With Style Properties:\n");
                for (Map.Entry entry : map1.entrySet()) {
                    IStylePropertySetter primaryKey = (IStylePropertySetter)entry.getValue();
                    String suffix = "";
                    if (deserializers.containsKey((Object)primaryKey)) {
                        suffix = " (with deserializer: `" + (TypeUtils.isFromParentPackage(((IDeserializer)deserializers.get((Object)primaryKey)).getClass(), myPackage) ? ((IDeserializer)deserializers.get((Object)primaryKey)).getClass().getSimpleName() : ((IDeserializer)deserializers.get((Object)primaryKey)).getClass().getName()) + "`)";
                    }
                    builder.append("  - **[_").append(((Class)classes.get((Object)primaryKey)).getSimpleName()).append("_]** ").append("`").append((String)entry.getKey()).append("`").append(suffix).append("\n");
                    if (setterCallbacksPre.containsKey((Object)primaryKey)) {
                        builder.append("    - Setter callback pre: `").append(((IStylePropertyCallbackPre)setterCallbacksPre.get((Object)primaryKey)).name()).append("`\n");
                    }
                    if (!setterCallbacksPost.containsKey((Object)primaryKey)) continue;
                    builder.append("    - Setter callback post: `").append(((IStylePropertyCallbackPost)setterCallbacksPost.get((Object)primaryKey)).name()).append("`\n");
                }
            }
            if (!(map2 = (Map)getters.get((Object)clazz.getName())).isEmpty()) {
                builder.append("- With Lerpable Properties:\n");
                for (LerpTarget lerpTarget : map2.values()) {
                    builder.append("  - ").append("`").append(lerpTarget.value());
                    if (!lerpTarget.inner0().isEmpty()) {
                        builder.append(".").append(lerpTarget.inner0());
                    }
                    if (!lerpTarget.inner1().isEmpty()) {
                        builder.append(".").append(lerpTarget.inner1());
                    }
                    builder.append("`").append("\n");
                }
            }
            builder.append("\n");
            if (index != count - 1) {
                builder.append("***\n\n");
            }
            ++index;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(FileUtils.makeFile("ui_element_dump.md", new String[0]), "rw");
            raf.setLength(0L);
            raf.seek(0L);
            raf.writeBytes(builder.toString());
            raf.close();
        }
        catch (IOException raf) {
            // empty catch block
        }
        InternalMethods.instance.IgiRuntime$init.invoke();
        IgiRuntime runtime = InternalMethods.instance.IgiRuntime$instance$getter.invoke();
        MinecraftForge.EVENT_BUS.post((Event)new IgiRuntimeEntryPointEvent(runtime));
    }
}

