/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate;

import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.NodePath;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NodePathImpl
implements NodePath {
    static final NodePath EMPTY = new NodePathImpl(new Object[0], false);
    private final Object[] arr;

    NodePathImpl(Object[] arr, boolean copy) {
        Objects.requireNonNull(arr);
        this.arr = copy ? Arrays.copyOf(arr, arr.length) : arr;
    }

    @Override
    public Object get(int i) {
        return this.arr[i];
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public NodePath withAppendedChild(Object childKey) {
        Objects.requireNonNull(childKey, "childKey");
        Object[] arr = this.arr;
        if (arr.length == 0) {
            return new NodePathImpl(new Object[]{childKey}, false);
        }
        Object[] childPath = Arrays.copyOf(arr, arr.length + 1);
        childPath[childPath.length - 1] = childKey;
        return new NodePathImpl(childPath, false);
    }

    @Override
    public NodePath with(int index, Object value) throws IndexOutOfBoundsException {
        Objects.requireNonNull(value, "value");
        Object[] arr = this.arr;
        if (index < 0 || index >= arr.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is not within limit of [0," + arr.length + ")");
        }
        Object[] newPath = Arrays.copyOf(arr, arr.length);
        newPath[index] = value;
        return new NodePathImpl(newPath, false);
    }

    @Override
    public NodePath plus(NodePath other) {
        Objects.requireNonNull(other, "other");
        if (this.arr.length == 0) {
            return other;
        }
        if (other.size() == 0) {
            return this;
        }
        Object[] otherArr = other instanceof NodePathImpl ? ((NodePathImpl)other).arr : other.array();
        Object[] result = new Object[this.arr.length + otherArr.length];
        System.arraycopy(this.arr, 0, result, 0, this.arr.length);
        System.arraycopy(otherArr, 0, result, this.arr.length, otherArr.length);
        return new NodePathImpl(result, false);
    }

    @Override
    public Object[] array() {
        return Arrays.copyOf(this.arr, this.arr.length);
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.arr).iterator();
    }

    @Override
    public NodePath copy() {
        return new NodePathImpl(this.arr, true);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NodePathImpl that = (NodePathImpl)other;
        return Arrays.equals(this.arr, that.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        return Arrays.toString(this.arr);
    }
}

