/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.commonutils;

import java.io.File;
import java.io.RandomAccessFile;

public final class FileUtils {
    private static final String parentPath = "config/ingameinfo/";

    private static File makeDir(String path) {
        File directory = new File(parentPath + path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public static File makeDir(String ... dir) {
        if (dir.length == 0) {
            return FileUtils.makeDir("");
        }
        return FileUtils.makeDir(String.join((CharSequence)"/", dir));
    }

    public static File makeFile(String fileName, String ... dir) {
        FileUtils.makeDir(dir);
        String filePath = dir.length == 0 ? parentPath + fileName : parentPath + String.join((CharSequence)"/", dir) + "/" + fileName;
        try {
            RandomAccessFile raf = new RandomAccessFile(filePath, "rw");
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(filePath);
    }

    public static File getFile(String fileName, String ... dir) {
        FileUtils.makeDir(dir);
        String filePath = dir.length == 0 ? parentPath + fileName : parentPath + String.join((CharSequence)"/", dir) + "/" + fileName;
        return new File(filePath);
    }
}

