/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.forgeevent.IgiGuiLifecycleInitEvent;
import com.tttsaurus.ingameinfo.common.core.forgeevent.IgiGuiLifecycleRegainScreenFocusEvent;
import com.tttsaurus.ingameinfo.common.core.function.IFunc;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.dummygui.DummyMcGui;
import com.tttsaurus.ingameinfo.common.core.gui.dummygui.IDummyDrawScreen;
import com.tttsaurus.ingameinfo.common.core.gui.dummygui.IDummyKeyTyped;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderDecorator;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderOpPhase;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.IVisualModifier;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.VisualBuilder;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.VisualBuilderAccessor;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.command.IArgsGenerator;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.command.VisualCommand;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.input.InputState;
import com.tttsaurus.ingameinfo.common.core.item.GhostableItem;
import com.tttsaurus.ingameinfo.common.core.render.RenderMask;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.Display;

public abstract class GuiLifecycleProvider {
    private String lifecycleHolderName;
    protected static final Minecraft MC = Minecraft.func_71410_x();
    protected ScaledResolution resolution = new ScaledResolution(MC);
    protected final Map<String, IgiGuiContainer> openedGuiMap = new LinkedHashMap<String, IgiGuiContainer>();
    private boolean listenRegainScreenFocus = false;
    private boolean initFlag = true;
    private boolean finishFirstUpdate = false;
    private boolean isDummyGuiOn = false;
    protected int maxFps_FixedUpdate = 125;
    protected double timePerFrame_FixedUpdate = 1.0 / (double)this.maxFps_FixedUpdate;
    protected int maxFps_RenderUpdate = 240;
    protected double timePerFrame_RenderUpdate = 1.0 / (double)this.maxFps_RenderUpdate;
    private final VisualBuilderAccessor visualBuilderAccessor;

    public GuiLifecycleProvider() {
        this.visualBuilderAccessor = InternalMethods.instance.VisualBuilderAccessor$constructor.invoke();
    }

    public String getLifecycleHolderName() {
        return this.lifecycleHolderName;
    }

    public final void openIgiGui(String mvvmRegistryName, IgiGuiContainer guiContainer) {
        if (this.openedGuiMap.containsKey(mvvmRegistryName)) {
            return;
        }
        this.openedGuiMap.put(mvvmRegistryName, guiContainer);
    }

    public final void closeIgiGui(String mvvmRegistryName) {
        this.openedGuiMap.remove(mvvmRegistryName);
    }

    protected abstract void updateInternal();

    protected boolean isDummyGuiOn() {
        return this.isDummyGuiOn;
    }

    public final void update(InputState inputState) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (this.initFlag) {
            this.initFlag = false;
            MinecraftForge.EVENT_BUS.post((Event)new IgiGuiLifecycleInitEvent(this.lifecycleHolderName));
        }
        if (!Display.isActive() && !this.listenRegainScreenFocus) {
            this.listenRegainScreenFocus = true;
        }
        if (Display.isActive() && this.listenRegainScreenFocus) {
            this.listenRegainScreenFocus = false;
            MinecraftForge.EVENT_BUS.post((Event)new IgiGuiLifecycleRegainScreenFocusEvent(this.lifecycleHolderName));
        }
        for (IgiGuiContainer igiGuiContainer : this.openedGuiMap.values()) {
            igiGuiContainer.onInit();
        }
        ScaledResolution newResolution = new ScaledResolution(MC);
        if (this.resolution.func_78325_e() != newResolution.func_78325_e() || this.resolution.func_78326_a() != newResolution.func_78326_a() || this.resolution.func_78328_b() != newResolution.func_78328_b()) {
            this.resolution = newResolution;
            for (IgiGuiContainer container : this.openedGuiMap.values()) {
                container.onScaledResolutionResize();
            }
        }
        if (this.finishFirstUpdate) {
            this.isDummyGuiOn = GuiLifecycleProvider.MC.field_71462_r instanceof DummyMcGui;
            if (this.isDummyGuiOn) {
                if (this.openedGuiMap.isEmpty()) {
                    this.isDummyGuiOn = false;
                    MC.func_147108_a(null);
                } else {
                    AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    this.openedGuiMap.forEach((uuid, guiContainer) -> focus.set(focus.get() || guiContainer.getFocused() && guiContainer.getActive()));
                    if (!atomicBoolean.get()) {
                        this.isDummyGuiOn = false;
                        MC.func_147108_a(null);
                    }
                }
            }
            if (!this.openedGuiMap.isEmpty() && GuiLifecycleProvider.MC.field_71462_r == null) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                this.openedGuiMap.forEach((uuid, guiContainer) -> focus.set(focus.get() || guiContainer.getFocused() && guiContainer.getActive()));
                if (atomicBoolean.get()) {
                    MC.func_147108_a((GuiScreen)this.newDummyGui());
                    this.isDummyGuiOn = true;
                }
            }
        }
        if (this.finishFirstUpdate) {
            for (IgiGuiContainer container : this.openedGuiMap.values()) {
                container.onPropagateInput(inputState);
            }
        }
        this.updateInternal();
        if (!this.finishFirstUpdate) {
            this.finishFirstUpdate = true;
        }
    }

    public final void setMaxFps_FixedUpdate(int fps) {
        this.maxFps_FixedUpdate = fps;
        this.timePerFrame_FixedUpdate = 1.0 / (double)this.maxFps_FixedUpdate;
    }

    protected final void definedFixedUpdate(double deltaTime) {
        for (IgiGuiContainer container : this.openedGuiMap.values()) {
            container.onFixedUpdate(deltaTime);
        }
    }

    public final void setMaxFps_RenderUpdate(int fps) {
        this.maxFps_RenderUpdate = fps;
        this.timePerFrame_RenderUpdate = 1.0 / (double)this.maxFps_RenderUpdate;
    }

    protected final void definedRenderUpdate() {
        ItemStack heldItemMainhand = null;
        EntityPlayerSP player = GuiLifecycleProvider.MC.field_71439_g;
        if (player != null) {
            heldItemMainhand = player.func_184614_ca();
        }
        ArrayList<Map.Entry<String, IgiGuiContainer>> entryList = new ArrayList<Map.Entry<String, IgiGuiContainer>>(this.openedGuiMap.entrySet());
        String firstFocused = "";
        for (int i = entryList.size() - 1; i >= 0; --i) {
            Map.Entry<String, IgiGuiContainer> entry = (Map.Entry<String, IgiGuiContainer>)entryList.get(i);
            if (!((IgiGuiContainer)entry.getValue()).getFocused()) continue;
            firstFocused = (String)entry.getKey();
            break;
        }
        for (Map.Entry<String, IgiGuiContainer> entry : this.openedGuiMap.entrySet()) {
            IRenderOp op;
            IgiGuiContainer container = entry.getValue();
            boolean display = true;
            if (heldItemMainhand != null) {
                if (container.getUseHeldItemWhitelist()) {
                    display = false;
                    for (GhostableItem item : container.getHeldItemWhitelist()) {
                        if (item.getItemStack() == null || !item.getItemStack().func_77969_a(heldItemMainhand)) continue;
                        display = true;
                    }
                }
                if (container.getUseHeldItemBlacklist()) {
                    for (GhostableItem item : container.getHeldItemBlacklist()) {
                        if (item.getItemStack() == null || !item.getItemStack().func_77969_a(heldItemMainhand)) continue;
                        display = false;
                    }
                }
            }
            if (!display) continue;
            RenderMask.resetStencilCounter();
            RenderContext context = new RenderContext(container.getThemeConfig(), this.getRenderLerpAlpha(), !this.isUsingFramebuffer() && !this.isUsingMultisampleFramebuffer(), !this.isUsingFramebuffer() && !this.isUsingMultisampleFramebuffer());
            RenderDecorator decorator = container.getRenderDecorator();
            RenderOpQueue queue = container.onRenderUpdate(entry.getKey().equals(firstFocused));
            while ((op = queue.dequeue()) != null) {
                op.readTheme(context.theme);
                if (!decorator.isEmpty() && decorator.isModifying(op.getClass())) {
                    VisualBuilder builder;
                    boolean abort = false;
                    List<IVisualModifier> modBefore = decorator.getModifiers(op.getClass(), RenderOpPhase.BEFORE_EXE);
                    List<IVisualModifier> modAfter = decorator.getModifiers(op.getClass(), RenderOpPhase.AFTER_EXE);
                    if (!modBefore.isEmpty()) {
                        builder = new VisualBuilder();
                        for (IVisualModifier iVisualModifier : modBefore) {
                            iVisualModifier.apply(builder);
                        }
                        this.visualBuilderAccessor.setVisualBuilder(builder);
                        abort = this.visualBuilderAccessor.getAbortRenderOp();
                        for (Tuple tuple : this.visualBuilderAccessor.getCommands()) {
                            ((VisualCommand)tuple.func_76341_a()).execute(((IArgsGenerator)tuple.func_76340_b()).genCommandArgs(context, op));
                        }
                    }
                    if (!abort) {
                        op.execute(context);
                    }
                    if (modAfter.isEmpty()) continue;
                    builder = new VisualBuilder();
                    for (IVisualModifier iVisualModifier : modAfter) {
                        iVisualModifier.apply(builder);
                    }
                    this.visualBuilderAccessor.setVisualBuilder(builder);
                    for (Tuple tuple : this.visualBuilderAccessor.getCommands()) {
                        ((VisualCommand)tuple.func_76341_a()).execute(((IArgsGenerator)tuple.func_76340_b()).genCommandArgs(context, op));
                    }
                    continue;
                }
                op.execute(context);
            }
        }
    }

    protected abstract boolean isUsingFramebuffer();

    protected abstract boolean isUsingMultisampleFramebuffer();

    protected abstract IDummyDrawScreen getDummyGuiDrawScreen();

    private DummyMcGui newDummyGui() {
        DummyMcGui dummyGui = new DummyMcGui();
        dummyGui.setDrawAction(this.getDummyGuiDrawScreen());
        dummyGui.setTypeAction(new IDummyKeyTyped(){

            @Override
            public void type(int keycode) {
                ArrayList<Map.Entry<String, IgiGuiContainer>> entryList = new ArrayList<Map.Entry<String, IgiGuiContainer>>(GuiLifecycleProvider.this.openedGuiMap.entrySet());
                String key = "";
                IFunc<Boolean> exitCallback = null;
                for (int i = entryList.size() - 1; i >= 0; --i) {
                    Map.Entry entry = (Map.Entry)entryList.get(i);
                    IgiGuiContainer container = (IgiGuiContainer)entry.getValue();
                    if (!container.getFocused() || keycode != container.getExitKeyForFocusedGui()) continue;
                    key = (String)entry.getKey();
                    exitCallback = container.getExitCallback();
                    break;
                }
                if (!key.isEmpty() && ((Boolean)exitCallback.invoke()).booleanValue()) {
                    GuiLifecycleProvider.this.openedGuiMap.remove(key);
                }
            }
        });
        return dummyGui;
    }

    public abstract float getRenderLerpAlpha();
}

