/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.render.decorator;

import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderOpPhase;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.visual.IVisualModifier;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RenderDecorator {
    private boolean empty = true;
    private final Map<Class<? extends IRenderOp>, Map<RenderOpPhase, List<IVisualModifier>>> visualModifiers = new HashMap<Class<? extends IRenderOp>, Map<RenderOpPhase, List<IVisualModifier>>>();
    private Class<? extends IRenderOp> currKey = null;
    private Map<RenderOpPhase, List<IVisualModifier>> currValue = null;

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isModifying(Class<? extends IRenderOp> targetOpType) {
        this.currKey = targetOpType;
        this.currValue = this.visualModifiers.get(targetOpType);
        return this.currValue != null;
    }

    public List<IVisualModifier> getModifiers(Class<? extends IRenderOp> targetOpType, RenderOpPhase phase) {
        List<IVisualModifier> list;
        if (Objects.equals(this.currKey, targetOpType)) {
            if (this.currValue == null) {
                return new ArrayList<IVisualModifier>();
            }
            List<IVisualModifier> value = this.currValue.get((Object)phase);
            if (value == null) {
                return new ArrayList<IVisualModifier>();
            }
            list = value;
        } else {
            Map<RenderOpPhase, List<IVisualModifier>> map = this.visualModifiers.get(targetOpType);
            if (map == null) {
                return new ArrayList<IVisualModifier>();
            }
            List<IVisualModifier> value = map.get((Object)phase);
            if (value == null) {
                return new ArrayList<IVisualModifier>();
            }
            list = value;
        }
        return list;
    }

    public void register(Class<? extends IRenderOp> targetOpType, RenderOpPhase phase, IVisualModifier visualModifier) {
        Map map = this.visualModifiers.computeIfAbsent(targetOpType, k -> new HashMap());
        List list = map.computeIfAbsent(phase, k -> new ArrayList());
        list.add(visualModifier);
        this.empty = false;
    }
}

