/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.theme.registry;

import com.tttsaurus.ingameinfo.InGameInfoReborn;
import com.tttsaurus.ingameinfo.common.core.commonutils.FileUtils;
import com.tttsaurus.ingameinfo.common.core.forgeevent.IgiGuiLifecycleRegainScreenFocusEvent;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfigSerDesUtils;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfigUpdater;
import com.tttsaurus.ingameinfo.config.IgiSpotifyIntegrationConfig;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ThemeRegistry {
    private static final Map<String, ThemeConfig> themeConfigs = new HashMap<String, ThemeConfig>();
    private static ThemeConfig defaultTheme;

    public static ThemeConfig getDefaultTheme() {
        return defaultTheme;
    }

    public static ThemeConfig getTheme(String themeName) {
        ThemeConfig themeConfig = themeConfigs.get(themeName);
        if (themeConfig == null) {
            return defaultTheme;
        }
        return themeConfig;
    }

    public static Set<String> getThemeNames() {
        return themeConfigs.keySet();
    }

    public static void init() {
        File[] files;
        if (!themeConfigs.containsKey("default")) {
            ThemeConfig defaultTheme = new ThemeConfig();
            try {
                File defaultFile = FileUtils.getFile("default.itheme", "themes");
                boolean writeDefault = !defaultFile.exists();
                RandomAccessFile file = new RandomAccessFile(defaultFile, "rw");
                StringBuilder builder = new StringBuilder();
                if (writeDefault) {
                    String config = ThemeConfigSerDesUtils.serialize(new ThemeConfig());
                    file.write(config.getBytes(StandardCharsets.UTF_8));
                    builder.append(config);
                } else {
                    String line = file.readLine();
                    while (line != null) {
                        builder.append(line).append("\n");
                        line = file.readLine();
                    }
                }
                ThemeConfigUpdater updater = ThemeConfigSerDesUtils.deserialize(builder.toString());
                if (updater.update()) {
                    String config = ThemeConfigSerDesUtils.serialize(updater.getConfig());
                    file.setLength(0L);
                    file.seek(0L);
                    file.write(config.getBytes(StandardCharsets.UTF_8));
                }
                defaultTheme = updater.getConfig();
                file.close();
            }
            catch (Exception exception) {
                InGameInfoReborn.LOGGER.error("Caught an exception when creating and loading the default theme.");
                InGameInfoReborn.LOGGER.throwing((Throwable)exception);
            }
            themeConfigs.put("default", defaultTheme);
            ThemeRegistry.defaultTheme = defaultTheme;
        }
        if (IgiSpotifyIntegrationConfig.ENABLE_SPOTIFY_INTEGRATION) {
            try {
                File spotify = FileUtils.getFile("spotify.itheme", "themes");
                if (!spotify.exists()) {
                    RandomAccessFile file = new RandomAccessFile(spotify, "rw");
                    ThemeConfig spotifyTheme = new ThemeConfig();
                    spotifyTheme.element.backgroundStyle = "mc-vanilla";
                    spotifyTheme.text.color = "#232323";
                    spotifyTheme.slidingText.color = "#232323";
                    spotifyTheme.animText.color = "#232323";
                    spotifyTheme.text.shadow = false;
                    spotifyTheme.slidingText.shadow = false;
                    spotifyTheme.animText.shadow = false;
                    String config = ThemeConfigSerDesUtils.serialize(spotifyTheme);
                    file.write(config.getBytes(StandardCharsets.UTF_8));
                    file.close();
                }
            }
            catch (Exception exception) {
                InGameInfoReborn.LOGGER.error("Caught an exception when creating the spotify theme.");
                InGameInfoReborn.LOGGER.throwing((Throwable)exception);
            }
        }
        if ((files = FileUtils.makeDir(new String[]{"themes"}).listFiles()) != null) {
            for (File file : files) {
                String[] args;
                if (!file.isFile() || file.getName().equals("default.itheme") || (args = file.getName().split("\\.")).length != 2 || !args[1].equals("itheme")) continue;
                String themeName = args[0];
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "rw");
                    StringBuilder builder = new StringBuilder();
                    String line = raf.readLine();
                    while (line != null) {
                        builder.append(line).append("\n");
                        line = raf.readLine();
                    }
                    ThemeConfigUpdater updater = ThemeConfigSerDesUtils.deserialize(builder.toString());
                    if (updater.update()) {
                        String config = ThemeConfigSerDesUtils.serialize(updater.getConfig());
                        raf.setLength(0L);
                        raf.seek(0L);
                        raf.write(config.getBytes(StandardCharsets.UTF_8));
                    }
                    themeConfigs.put(themeName, updater.getConfig());
                    raf.close();
                }
                catch (Exception exception) {
                    InGameInfoReborn.LOGGER.error("Caught an exception when loading the theme config '" + themeName + "'.");
                    InGameInfoReborn.LOGGER.throwing((Throwable)exception);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRegainScreenFocus(IgiGuiLifecycleRegainScreenFocusEvent event) {
        InGameInfoReborn.LOGGER.info("Regain screen focus. Trying to reload theme configs...");
        File[] files = FileUtils.makeDir(new String[]{"themes"}).listFiles();
        if (files != null) {
            for (File file : files) {
                long fiveMinutesAgo;
                String[] args;
                if (!file.isFile() || (args = file.getName().split("\\.")).length != 2 || !args[1].equals("itheme")) continue;
                String themeName = args[0];
                long lastModified = file.lastModified();
                if (lastModified <= (fiveMinutesAgo = System.currentTimeMillis() - 300000L)) continue;
                InGameInfoReborn.LOGGER.info("Theme config '" + themeName + "' was modified within 5 minutes. Start reloading.");
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "rw");
                    StringBuilder builder = new StringBuilder();
                    String line = raf.readLine();
                    while (line != null) {
                        builder.append(line).append("\n");
                        line = raf.readLine();
                    }
                    ThemeConfigUpdater updater = ThemeConfigSerDesUtils.deserialize(builder.toString());
                    if (updater.update()) {
                        String config = ThemeConfigSerDesUtils.serialize(updater.getConfig());
                        raf.setLength(0L);
                        raf.seek(0L);
                        raf.write(config.getBytes(StandardCharsets.UTF_8));
                    }
                    themeConfigs.put(themeName, updater.getConfig());
                    raf.close();
                    InGameInfoReborn.LOGGER.info("Theme config '" + themeName + "' reloaded.");
                }
                catch (Exception exception) {
                    InGameInfoReborn.LOGGER.error("Caught an exception when reloading the theme config '" + themeName + "'.");
                    InGameInfoReborn.LOGGER.throwing((Throwable)exception);
                }
            }
        }
    }
}

