/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.compose;

import java.util.ArrayList;
import java.util.Map;

public class UpdatePlan {
    public final int index;
    public final ActionType actionType;
    public String newElementName;
    public Map<String, Object> newStyleProperties;
    public int swapIndex;
    public String stylePropertyName;
    public Object stylePropertyOverride;

    public UpdatePlan(int index, ActionType actionType) {
        this.index = index;
        this.actionType = actionType;
    }

    public String toString() {
        String string;
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: {
                StringBuilder builder = new StringBuilder();
                builder.append("ADD ").append(this.newElementName).append(" at ").append(this.index);
                ArrayList<String> props = new ArrayList<String>();
                for (Map.Entry<String, Object> prop : this.newStyleProperties.entrySet()) {
                    props.add(prop.getKey() + "=" + prop.getValue().toString());
                }
                if (!props.isEmpty()) {
                    builder.append(" (").append(String.join((CharSequence)", ", props)).append(")");
                }
                string = builder.toString();
                break;
            }
            case SWAP: {
                string = "SWAP " + this.index + " <-> " + this.swapIndex;
                break;
            }
            case REMOVE: {
                string = "REMOVE at " + this.index;
                break;
            }
            case UPDATE_PROP: {
                string = "UPDATE_PROP at " + this.index + " (" + this.stylePropertyName + "=" + this.stylePropertyOverride + ")";
                break;
            }
            case GOTO_NEXT_LAYER: {
                string = "GOTO_NEXT_LAYER at " + this.index;
                break;
            }
            case GOTO_PREV_LAYER: {
                string = "GOTO_PREV_LAYER";
            }
        }
        return string;
    }

    public static enum ActionType {
        ADD,
        SWAP,
        REMOVE,
        UPDATE_PROP,
        GOTO_NEXT_LAYER,
        GOTO_PREV_LAYER;

    }
}

