/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.registry;

import com.tttsaurus.ingameinfo.InGameInfoReborn;
import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLayout;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveCollectionGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveObjectGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ISlotAccessorGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.registry.RegistryUtils;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MvvmRegistry {
    private final Map<String, IgiGuiContainer> igiGuiContainerCache = new HashMap<String, IgiGuiContainer>();
    private final Map<String, Map<Reactive, IReactiveObjectGetter>> registeredReactiveObjects = new HashMap<String, Map<Reactive, IReactiveObjectGetter>>();
    private final Map<String, Map<Reactive, IReactiveCollectionGetter>> registeredReactiveCollections = new HashMap<String, Map<Reactive, IReactiveCollectionGetter>>();
    private final Map<String, Map<Reactive, ISlotAccessorGetter>> registeredSlotAccessors = new HashMap<String, Map<Reactive, ISlotAccessorGetter>>();
    private final Map<String, Class<? extends ViewModel<?>>> viewModelClasses = new HashMap();

    @Nullable
    public IgiGuiContainer getIgiGuiContainer(String mvvmRegistryName) {
        if (!this.isMvvmRegistered(mvvmRegistryName)) {
            return null;
        }
        return this.igiGuiContainerCache.get(mvvmRegistryName);
    }

    public void cacheIgiGuiContainer(String mvvmRegistryName, @Nonnull ViewModel<?> viewModel) {
        GuiLayout guiLayout = InternalMethods.instance.ViewModel$init.invoke(viewModel, mvvmRegistryName, this);
        IgiGuiContainer igiGuiContainer = InternalMethods.instance.GuiLayout$igiGuiContainer$getter.invoke(guiLayout);
        InternalMethods.instance.IgiGuiContainer$viewModel$setter.invoke(igiGuiContainer, viewModel);
        this.igiGuiContainerCache.put(mvvmRegistryName, igiGuiContainer);
        InGameInfoReborn.LOGGER.info("Generated and cached IgiGuiContainer for '" + mvvmRegistryName + "'.");
    }

    public Map<Reactive, IReactiveObjectGetter> getRegisteredReactiveObjects(String mvvmRegistryName) {
        Map<Reactive, IReactiveObjectGetter> map = this.registeredReactiveObjects.get(mvvmRegistryName);
        if (map == null) {
            return new HashMap<Reactive, IReactiveObjectGetter>();
        }
        return map;
    }

    public Map<Reactive, IReactiveCollectionGetter> getRegisteredReactiveCollections(String mvvmRegistryName) {
        Map<Reactive, IReactiveCollectionGetter> map = this.registeredReactiveCollections.get(mvvmRegistryName);
        if (map == null) {
            return new HashMap<Reactive, IReactiveCollectionGetter>();
        }
        return map;
    }

    public Map<Reactive, ISlotAccessorGetter> getRegisteredSlotAccessors(String mvvmRegistryName) {
        Map<Reactive, ISlotAccessorGetter> map = this.registeredSlotAccessors.get(mvvmRegistryName);
        if (map == null) {
            return new HashMap<Reactive, ISlotAccessorGetter>();
        }
        return map;
    }

    public boolean isMvvmRegistered(String mvvmRegistryName) {
        return this.viewModelClasses.containsKey(mvvmRegistryName);
    }

    @Nullable
    public ViewModel<?> newViewModel(String mvvmRegistryName) {
        try {
            return this.viewModelClasses.get(mvvmRegistryName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean manualRegister(String mvvmRegistryName, Class<? extends ViewModel<?>> viewModelClass) {
        if (this.viewModelClasses.containsKey(mvvmRegistryName)) {
            return false;
        }
        InGameInfoReborn.LOGGER.info("Currently registering MVVM '" + mvvmRegistryName + "'.");
        this.viewModelClasses.put(mvvmRegistryName, viewModelClass);
        this.registeredReactiveObjects.put(mvvmRegistryName, RegistryUtils.findReactiveObjects(mvvmRegistryName, viewModelClass));
        this.registeredReactiveCollections.put(mvvmRegistryName, RegistryUtils.findReactiveCollections(mvvmRegistryName, viewModelClass));
        this.registeredSlotAccessors.put(mvvmRegistryName, RegistryUtils.findSlotAccessors(mvvmRegistryName, viewModelClass));
        return true;
    }

    public boolean autoRegister(String mvvmRegistryName, Class<? extends ViewModel<?>> viewModelClass) {
        if (!this.manualRegister(mvvmRegistryName, viewModelClass)) {
            return false;
        }
        this.cacheIgiGuiContainer(mvvmRegistryName, this.newViewModel(mvvmRegistryName));
        return true;
    }
}

