/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.view;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.commonutils.FileUtils;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLayout;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.MainGroup;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderDecorator;
import com.tttsaurus.ingameinfo.common.core.serialization.ixml.RawIxmlUtils;
import com.tttsaurus.ingameinfo.common.impl.serialization.GuiLayoutDeserializer;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class View {
    private RenderDecorator renderDecorator;
    private MainGroup mainGroup = null;

    public void initRenderDecorator(RenderDecorator renderDecorator) {
    }

    public RenderDecorator getRenderDecorator() {
        return this.renderDecorator;
    }

    public final List<Element> getElements(String uid) {
        return this.getElements(this.mainGroup, uid);
    }

    private final List<Element> getElements(ElementGroup group, String uid) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : group.elements) {
            if (element.uid.equals(uid)) {
                list.add(element);
            }
            if (!ElementGroup.class.isAssignableFrom(element.getClass())) continue;
            ElementGroup nextGroup = (ElementGroup)element;
            list.addAll(this.getElements(nextGroup, uid));
        }
        return list;
    }

    public final void refresh(IgiGuiContainer container) {
        if (this.mainGroup == null) {
            return;
        }
        GuiLayout guiLayout = this.init(container);
        MainGroup mainGroup = InternalMethods.instance.GuiLayout$mainGroup$getter.invoke(guiLayout);
        this.mainGroup.elements.clear();
        for (Element element : mainGroup.elements) {
            this.mainGroup.add(element);
        }
    }

    public String getDefaultIxml() {
        return "";
    }

    public abstract String getIxmlFileName();

    private final GuiLayout init(@Nullable IgiGuiContainer container) {
        try {
            File testFile = FileUtils.getFile(this.getIxmlFileName() + ".ixml", "ixml");
            boolean writeDefault = !testFile.exists();
            RandomAccessFile file = new RandomAccessFile(testFile, "rw");
            StringBuilder builder = new StringBuilder();
            if (writeDefault) {
                file.write(this.getDefaultIxml().getBytes(StandardCharsets.UTF_8));
                builder.append(this.getDefaultIxml().replace("\n", ""));
            } else {
                String line = file.readLine();
                while (line != null) {
                    builder.append(line);
                    line = file.readLine();
                }
            }
            file.close();
            return new GuiLayoutDeserializer(container).deserialize(RawIxmlUtils.deleteComments(builder.toString()));
        }
        catch (Exception ignored) {
            return InternalMethods.instance.GuiLayout$constructor.invoke();
        }
    }
}

