/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.function.IAction_1Param;
import com.tttsaurus.ingameinfo.common.core.function.IFunc;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLayout;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.event.IUIEventListener;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderDecorator;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.EventListenerBinder;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveCollectionGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveObjectGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ISlotAccessorGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveCollection;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.SlotAccessor;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.VvmBinding;
import com.tttsaurus.ingameinfo.common.core.mvvm.context.SharedContext;
import com.tttsaurus.ingameinfo.common.core.mvvm.registry.MvvmRegistry;
import com.tttsaurus.ingameinfo.common.core.mvvm.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ViewModel<T extends View> {
    private VvmBinding<T> binding = new VvmBinding();
    private String mvvmRegistryName;
    private final List<SlotAccessor> slotAccessors = new ArrayList<SlotAccessor>();
    private final EventListenerBinder eventListenerBinder = new EventListenerBinder();
    protected final SharedContext sharedContext = new SharedContext();
    private IAction_1Param<Boolean> isActiveSetter = null;
    private IFunc<Boolean> isActiveGetter = null;
    private IAction_1Param<IFunc<Boolean>> exitCallbackSetter = null;
    private IAction_1Param<Boolean> isFocusedSetter = null;
    private IFunc<Boolean> isFocusedGetter = null;

    private RenderDecorator getRenderDecorator() {
        return ((View)this.binding.view).getRenderDecorator();
    }

    public final String getMvvmRegistryName() {
        return this.mvvmRegistryName;
    }

    public final <T extends UIEvent> void bindEventListener(String uid, Class<T> type, IUIEventListener<T> listener) {
        this.eventListenerBinder.bind((View)this.binding.view, uid, type, listener, -1);
    }

    public final <T extends UIEvent> void bindEventListener(String uid, Class<T> type, IUIEventListener<T> listener, int ordinal) {
        this.eventListenerBinder.bind((View)this.binding.view, uid, type, listener, ordinal);
    }

    public void setActive(boolean flag) {
        if (this.isActiveSetter == null) {
            return;
        }
        this.isActiveSetter.invoke(flag);
    }

    public boolean getActive() {
        if (this.isActiveGetter == null) {
            return false;
        }
        return this.isActiveGetter.invoke();
    }

    public void setExitCallback(IFunc<Boolean> callback) {
        if (this.exitCallbackSetter == null) {
            return;
        }
        this.exitCallbackSetter.invoke(callback);
    }

    public void setFocused(boolean flag) {
        if (this.isFocusedSetter == null) {
            return;
        }
        this.isFocusedSetter.invoke(flag);
    }

    public boolean getFocused() {
        if (this.isFocusedGetter == null) {
            return false;
        }
        return this.isFocusedGetter.invoke();
    }

    private GuiLayout init(String mvvmRegistryName, MvvmRegistry mvvmRegistry) {
        this.mvvmRegistryName = mvvmRegistryName;
        GuiLayout guiLayout = this.binding.init(this, mvvmRegistryName);
        Map<Reactive, IReactiveObjectGetter> reactiveObjects = mvvmRegistry.getRegisteredReactiveObjects(mvvmRegistryName);
        for (Map.Entry<Reactive, IReactiveObjectGetter> entry : reactiveObjects.entrySet()) {
            this.binding.bindReactiveObject(entry.getKey(), entry.getValue().get(this));
        }
        Map<Reactive, IReactiveCollectionGetter> reactiveCollections = mvvmRegistry.getRegisteredReactiveCollections(mvvmRegistryName);
        for (Map.Entry<Reactive, IReactiveCollectionGetter> entry : reactiveCollections.entrySet()) {
            this.binding.bindReactiveCollection(entry.getKey(), entry.getValue().get(this));
        }
        this.slotAccessors.clear();
        Map<Reactive, ISlotAccessorGetter> map = mvvmRegistry.getRegisteredSlotAccessors(mvvmRegistryName);
        for (Map.Entry<Reactive, ISlotAccessorGetter> entry : map.entrySet()) {
            SlotAccessor slotAccessor = entry.getValue().get(this);
            this.slotAccessors.add(slotAccessor);
            this.binding.bindSlotAccessor(entry.getKey(), slotAccessor);
        }
        return guiLayout;
    }

    public final void refresh(IgiGuiContainer container, MvvmRegistry mvvmRegistry) {
        if (this.binding.view == null) {
            return;
        }
        ((View)this.binding.view).refresh(container);
        Map<Reactive, IReactiveObjectGetter> reactiveObjects = mvvmRegistry.getRegisteredReactiveObjects(this.mvvmRegistryName);
        for (Map.Entry<Reactive, IReactiveObjectGetter> entry : reactiveObjects.entrySet()) {
            ReactiveObject<?> reactiveObject = entry.getValue().get(this);
            InternalMethods.instance.ReactiveObject$initiativeCallbacks$getter.invoke(reactiveObject).clear();
            InternalMethods.instance.ReactiveObject$passiveCallbacks$getter.invoke(reactiveObject).clear();
            this.binding.bindReactiveObject(entry.getKey(), reactiveObject);
        }
        Map<Reactive, IReactiveCollectionGetter> reactiveCollections = mvvmRegistry.getRegisteredReactiveCollections(this.mvvmRegistryName);
        for (Map.Entry<Reactive, IReactiveCollectionGetter> entry : reactiveCollections.entrySet()) {
            ReactiveCollection reactiveCollection = entry.getValue().get(this);
            InternalMethods.instance.ReactiveCollection$group$setter.invoke(reactiveCollection, null);
            this.binding.bindReactiveCollection(entry.getKey(), reactiveCollection);
        }
        this.slotAccessors.clear();
        Map<Reactive, ISlotAccessorGetter> map = mvvmRegistry.getRegisteredSlotAccessors(this.mvvmRegistryName);
        for (Map.Entry<Reactive, ISlotAccessorGetter> entry : map.entrySet()) {
            SlotAccessor slotAccessor = entry.getValue().get(this);
            this.slotAccessors.add(slotAccessor);
            InternalMethods.instance.SlotAccessor$group$setter.invoke(slotAccessor, null);
            this.binding.bindSlotAccessor(entry.getKey(), slotAccessor);
        }
    }

    public abstract void onStart();

    public abstract void onFixedUpdate(double var1);
}

